package com.bizunited.platform.core.entity;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;

/**
 * 柯伊伯表单引擎服务方法详细属性描述
 * @author yinwenjie
 */
@ApiModel(value = "ServicableMethodPropertyEntity" , description="柯伊伯表单引擎服务方法详细属性描述")
@Entity
@Table(name="engine_service_method_property")
@org.hibernate.annotations.Table(appliesTo = "engine_service_method_property" , comment = "柯伊伯表单引擎服务方法详细属性描述")
public class ServicableMethodPropertyEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 7795122000695826215L;
  /**
   * 当前服务属性对应的表单引擎服务信息
   */
  @ApiModelProperty(name="serviceMethod" , value="当前服务属性对应的表单引擎服务信息")
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="service_method_id" , nullable=false, columnDefinition = "varchar(255) COMMENT '当前服务属性对应的表单引擎服务信息'")
  @SaturnColumn(description="表单引擎服务信息")
  private ServicableMethodEntity serviceMethod;
  /**
   * 参数的索引号，0表示第一个位置的参数。注意index的顺序不一定连续，这是因为有一些参数不一定在调用时传入
   */
  @ApiModelProperty(name="propertyIndex" , value="参数的索引号，0表示第一个位置的参数。注意index的顺序不一定连续，这是因为有一些参数不一定在调用时传入")
  @Column(name="property_index" , nullable=false, columnDefinition = "int(11) COMMENT '参数的索引号，0表示第一个位置的参数。注意index的顺序不一定连续，这是因为有一些参数不一定在调用时传入'")
  @SaturnColumn(description="参数的索引号")
  private Integer propertyIndex;
  /**
   * 参数类型：
   * 1、基础类型 -- 规定的类型<br>
   * 2、Principal允许多个，但Principal只能是操作者信息<br>
   * 3、分页Pageable对象，只允许一个<br>
   * 4、formData形式表单的数据 <br>
   * 5、Map类型<br>
   */
  @ApiModelProperty(name="paramType" , value="参数类型："
      + "1、基础类型 -- 规定的类型"
      + "2、Principal允许多个，但Principal只能是操作者信息"
      + "3、分页Pageable对象，只允许一个"
      + "4、formData形式表单的数据"
      + "5、Map类型")
  @Column(name="param_type" , nullable=false, columnDefinition = "int(11) COMMENT '参数类型：1、基础类型 -- 规定的类型2、Principal允许多个，但Principal只能是操作者信息3、分页Pageable对象，只允许一个4、formData形式表单的数据5、Map类型'")
  @SaturnColumn(description="参数类型标识")
  private Integer paramType;
  /**
   * 如果当前参数是“以Object类型对象的方式”，则该属性说明业务类型的完整类名
   */
  @ApiModelProperty(name="modelType" , value="如果当前参数是“以Model Object类型对象的方式”，则该属性说明业务类型的完整类名")
  @Column(name="model_type" , nullable=true, columnDefinition = "varchar(255) COMMENT '如果当前参数是“以Object类型对象的方式”，则该属性说明业务类型的完整类名'")
  @SaturnColumn(description="业务类型的完整类名")
  private String modelType;
  /**
   * 如果当前参数类型与其他参数类型相同，且是规定的基础类型时，需要指定当前参数的限定名。实际传参时，按指定的限定名传参
   */
  @ApiModelProperty(name="annonQualifiedName" , value="如果当前参数类型与其他参数类型相同，且是规定的基础类型时，需要指定当前参数的限定名。实际传参时，按指定的限定名传参")
  @Column(name="annon_qualified_name" , nullable=true , columnDefinition = "varchar(255) COMMENT '如果当前参数类型与其他参数类型相同，且是规定的基础类型时，需要指定当前参数的限定名。实际传参时，按指定的限定名传参'")
  @SaturnColumn(description="参数的限定名")
  private String annonQualifiedName;
  /**
   * 参数的类型值（如：java.lang.Integer   java.lang.Double）
   * 注：有一些特殊的字符代表，代表的是数组类型
   */
  @ApiModelProperty(name="paramClass" , value="参数的类型值（注：java.lang.Integer   java.lang.Double）")
  @Column(name="param_class" , nullable=true , columnDefinition = "varchar(255) COMMENT '参数的类型值（如：java.lang.Integer   java.lang.Double）'")
  @SaturnColumn(description="参数的类类型值")
  private String paramClass;
  
  public String getParamClass() {
    return paramClass;
  }
  public void setParamClass(String paramClass) {
    this.paramClass = paramClass;
  }
  public String getAnnonQualifiedName() {
    return annonQualifiedName;
  }
  public void setAnnonQualifiedName(String annonQualifiedName) {
    this.annonQualifiedName = annonQualifiedName;
  }
  public ServicableMethodEntity getServiceMethod() {
    return serviceMethod;
  }
  public void setServiceMethod(ServicableMethodEntity serviceMethod) {
    this.serviceMethod = serviceMethod;
  }
  public Integer getPropertyIndex() {
    return propertyIndex;
  }
  public void setPropertyIndex(Integer propertyIndex) {
    this.propertyIndex = propertyIndex;
  }
  public Integer getParamType() {
    return paramType;
  }
  public void setParamType(Integer paramType) {
    this.paramType = paramType;
  }
  public String getModelType() {
    return modelType;
  }
  public void setModelType(String modelType) {
    this.modelType = modelType;
  }

}
