package com.bizunited.platform.core.repository;

import com.bizunited.platform.core.entity.DictCategoryEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * DictCategoryRepository
 *
 * @description:
 * @author: yanwe
 * @date: 11/Jun/2019 17:26
 */
@Repository("DictCategoryRepository")
public interface DictCategoryRepository extends JpaSpecificationExecutor<DictCategoryEntity>, JpaRepository<DictCategoryEntity,String> {

  /**
   * 根据名称查询（名字唯一）
   * @param cateName
   * @return
   */
  DictCategoryEntity findByCateCode(String cateCode);
  /**
   * 根据id查询字典分类的基本信息和关联信息（但是不包括字典分类的子级集合关联）
   * @param id
   * @return
   */
  @Query("from DictCategoryEntity dc "
      + " left join fetch dc.parentCategory dcp "
      + " where dc.id = :id ")
  DictCategoryEntity findDetailsById(@Param("id") String id);
  /**
   * 树级结构查询，查询包括字典分组，字典分组下的字典，不包括字典明细数据
   * @return
   */
  @Query(value = "select dce from DictCategoryEntity dce "
      + " left join dce.childCategory "
      + " left join dce.dicts "
      + " where dce.parentCategory = null order by dce.createTime ")
  Set<DictCategoryEntity> findByTree();
}