package com.bizunited.platform.core.repository;

import com.bizunited.platform.core.entity.DictEntity;
import com.bizunited.platform.core.entity.DictItemEntity;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * DictItemRopositoy
 *
 * @description:
 * @author: yanwe
 * @date: 13/Feb/2019 10:40
 */
@Repository("DictItemRepository")
public interface DictItemRepository extends JpaRepository<DictItemEntity, String>, JpaSpecificationExecutor<DictItemEntity> {

    List<DictItemEntity> findByDictEntity(DictEntity dictEntity);

    List<DictItemEntity> findByDictEntityOrderByDictSort(DictEntity dictEntity);

    @Query(value = "select di from DictItemEntity di left join di.dictEntity where di.id = :id")
    DictItemEntity findDetailById(@Param("id")String id);
}
