package com.bizunited.platform.core.repository;

import java.lang.String;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.core.entity.DynamicTaskSchedulerLogEntity;
import com.bizunited.platform.core.repository.internal.DynamicTaskSchedulerLogRepositoryCustom;

/**
 * DynamicTaskSchedulerLogEntity业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_DynamicTaskSchedulerLogEntityRepository")
public interface DynamicTaskSchedulerLogRepository
    extends
      JpaRepository<DynamicTaskSchedulerLogEntity, String>
      ,JpaSpecificationExecutor<DynamicTaskSchedulerLogEntity>
      ,DynamicTaskSchedulerLogRepositoryCustom 
  {
  /**
   * 按照对应的动态日志进行详情查询（包括关联信息），这里查询的是
   * @param id
   * */
  @Query("select distinct dynamicTaskSchedulerLogEntity from DynamicTaskSchedulerLogEntity dynamicTaskSchedulerLogEntity "
      + " left join fetch dynamicTaskSchedulerLogEntity.dynamicTaskScheduler dynamicTaskSchedulerLogEntity_dynamicTaskScheduler "
       + " where dynamicTaskSchedulerLogEntity_dynamicTaskScheduler.id = :id order by dynamicTaskSchedulerLogEntity.startTime desc")
  public Set<DynamicTaskSchedulerLogEntity> findDetailsByDynamicTaskScheduler(@Param("id") String id);

  /**
   * 按照主键进行详情查询（包括关联信息），这里查询的是
   * @param id 主键
   * */
  @Query("select distinct dynamicTaskSchedulerLogEntity from DynamicTaskSchedulerLogEntity dynamicTaskSchedulerLogEntity "
      + " left join fetch dynamicTaskSchedulerLogEntity.dynamicTaskScheduler dynamicTaskSchedulerLogEntity_dynamicTaskScheduler "
      + " where dynamicTaskSchedulerLogEntity.id=:id ")
  public DynamicTaskSchedulerLogEntity findDetailsById(@Param("id") String id);


}