package com.bizunited.platform.core.repository;

import com.bizunited.platform.core.entity.RemoteServiceEntity;
import com.bizunited.platform.core.repository.internal.RemoteServiceRepositoryCustom;

import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * RemoteServiceRepository
 *
 * @description:
 * @author: yanwe
 * @date: 06/May/2019 09:40
 */
@Repository("RemoteServiceRepository")
public interface RemoteServiceRepository
    extends
      JpaRepository<RemoteServiceEntity, String>,
      JpaSpecificationExecutor<RemoteServiceEntity>,
      RemoteServiceRepositoryCustom {

  /**
   * 根据远端服务源的系统唯一业务编号，查询基本信息
   * @param code 全系统唯一的业务编码
   * @return
   */
  public RemoteServiceEntity findByCode(String code);
  /**
   * 根据一个或者多个远端服务源的ID信息，查询其基本信息和关联信息
   * @param remoteServiceIds 
   * @return
   */
  @Query("from RemoteServiceEntity rse left join fetch rse.remoteServiceAddress rsa where rse.id in (:remoteServiceIds)")
  Set<RemoteServiceEntity> findDetailsByIds(@Param("remoteServiceIds") String[] remoteServiceIds); 
  /**
   * 按照指定的远端调用源的ID信息，查询最终满足这些id编号的数据条目。<br>
   * 这个方法一般用于验证一批给定的id，是否都能在系统中找到对应的数据
   * @param ids 指定的id信息
   * @return 满足的条目数量将会被返回
   */
  @Query(value="select count(id) from engine_remote_service where engine_remote_service.id in (:ids)" , nativeQuery = true) 
  int countByIds(@Param("ids") String[] ids);
}