package com.bizunited.platform.core.repository;

import com.bizunited.platform.core.entity.RoleEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

/**
 * @author yinwenjie
 */
@Repository("RoleRepository")
public interface RoleRepository
    extends
      JpaRepository<RoleEntity, String>,
      JpaSpecificationExecutor<RoleEntity> {
  
  /**
   * 按照指定的用户id，删除目前这个用户已经有的绑定信息
   * @param userId
   */
  @Modifying
  @Query(value="delete from engine_role_user_mapping where user_id = :userId" , nativeQuery=true)
  void deleteRoleByUserId(@Param("userId") String userId);
  /**
   * 形成用户和角色的绑定关系，如果重复绑定，则会报错
   * @param userId
   * @param roleId
   */
  @Modifying
  @Query(value="insert into engine_role_user_mapping(role_id , user_id) values (:roleId , :userId)" , nativeQuery=true)
  void bindUser(@Param("userId") String userId ,@Param("roleId") String roleId);
  /**
   * 形成功能和角色的绑定关系，如果重复绑定，则会报错
   * @param competenceId
   * @param roleId
   */
  @Modifying
  @Query(value="insert into engine_role_competence_mapping(role_id , competence_id) values (:roleId , :competenceId)" , nativeQuery=true)
  void bindCompetence(@Param("competenceId") String competenceId ,@Param("roleId") String roleId);
  /**
   * 查询符合角色状态的信息
   * @param useStatus
   * @return
   */
  List<RoleEntity> findByTstatus(@Param("useStatus") Integer useStatus);
  /**
   * 按照填写的角色业务编号进行判断
   * @param roleCode
   * @return
   */
  RoleEntity findByRoleCode(String roleCode);
  /**
   * 查询指定的后台用户所绑定的角色信息(只包括角色基本信息)
   * @return
   */
  @Query("select distinct r from RoleEntity r left join fetch r.users a where a.id = :userId")
  List<RoleEntity> findByUserId(@Param("userId") String userId);
  /**
   * 查询指定的功能描述所绑定的角色信息
   * @param competenceId 功能描述信息
   * @return 
   */
  @Query("select distinct r from RoleEntity r left join fetch r.competences c where c.id = :competenceId")
  List<RoleEntity> findByCompetenceId(@Param("competenceId") String competenceId);
  /**
   * 按照角色名，查询指定的角色信息
   * @param roleName
   * @return
   */
  RoleEntity findByRoleName(String roleName);

  /**
   * 查询多个角色信息
   * @param ids
   * @return
   */
  @Query("from RoleEntity m where m.id in :ids")
  Set<RoleEntity> findByIds(@Param("ids") List<String> ids);
}
