package com.bizunited.platform.core.repository;

import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.repository.internal.ScriptRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.stereotype.Repository;

/**
 * ScriptRepository
 *
 * @description:
 * @author: yanwe
 * @date: 27/May/2019 11:04
 */
@Repository("ScriptRepository")
public interface ScriptRepository
    extends JpaRepository<ScriptEntity, String>,
        JpaSpecificationExecutor<ScriptEntity>,
        ScriptRepositoryCustom {


  /**
   * 按照脚本名称进行查询
   * @param name
   * @return
   */
  ScriptEntity findByName(String name);
}
