package com.bizunited.platform.core.repository;


import com.bizunited.platform.core.entity.ServicableMethodEntity;
import com.bizunited.platform.core.repository.internal.ServicableMethodRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository("ServicableMethodRepository")
public interface ServicableMethodRepository
    extends
      JpaRepository<ServicableMethodEntity, String>,
      JpaSpecificationExecutor<ServicableMethodEntity>,
    ServicableMethodRepositoryCustom {

  /* (non-Javadoc)
   * @see org.springframework.data.repository.CrudRepository#deleteAll()
   */
  @Modifying
  @Query(value="delete from engine_service_method " , nativeQuery=true)
  public void deleteAll();
  
  /**
   * 根据服务名，查询服务的详情信息
   * @param name
   * @return
   */
  @Query("from ServicableMethodEntity sm "
      + "left join fetch sm. properties smp  "
      + "where sm.name = :name")
  public ServicableMethodEntity queryDetailsByName(@Param("name") String name);

  /**
   * 根据name值  查询服务源信息
   * @param name
   * @return
   */
  @Query("from ServicableMethodEntity sm where sm.name= :name")
  public ServicableMethodEntity queryByName(@Param("name") String name);
}