package com.bizunited.platform.core.repository;

import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.repository.internal.UserRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;
import java.util.Set;

@Repository("UserRepository")
public interface UserRepository
    extends
      JpaRepository<UserEntity, String>,
      JpaSpecificationExecutor<UserEntity>,
      UserRepositoryCustom {
  /**
   * 成功登陆后，更新用户最后一次登录时间
   * @param account 按照用户账号更新
   */
  @Modifying
  @Query(value="update engine_user set lastlogin_time = :lastloginTime where user_account = :account " , nativeQuery = true)
  public void updateLastloginTime(@Param("account") String account ,@Param("lastloginTime") Date lastloginTime);
  /**
   * 按照指定的账户名，查询账户基本信息
   * 
   * @param account 账户名
   * @return
   */
  @Query("from UserEntity u where u.account = :account")
  public UserEntity findByAccount(@Param("account") String account);
  /**
   * 查询当前用户信息（按照用户账户编号），且包括当前用户已经绑定的用户组、组织机构和岗位</br>
   * 但是不包括当前用户绑定（包括间接绑定）的角色信息，因为要单独查询
   * @param id 指定的用户编号
   * @return
   */
  @Query("select distinct m from UserEntity m "
      + " left join fetch m.orgs "
      + " left join fetch m.groups "
      + " left join fetch m.positions where m.id = :id ")
  public UserEntity findDetailsById(@Param("id") String id);
  /**
   * 按照指定的联系电话，查询用户信息
   * @param phone
   * @return
   */
  public UserEntity findByPhone(String phone);
  /**
   * 根据ids集合，查询多个用户信息
   * @param ids
   * @return
   */
  @Query("from UserEntity m where m.id in :ids")
  public Set<UserEntity> findByIds(@Param("ids") List<String> ids);
}