package com.bizunited.platform.core.repository.dataview;

import com.bizunited.platform.core.entity.DataViewAuthHorizontalRelationEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * DataViewAuthHorizontalRelationEntity业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_DataViewAuthHorizontalRelationRepository")
public interface DataViewAuthHorizontalRelationRepository
    extends
      JpaRepository<DataViewAuthHorizontalRelationEntity, String>
      ,JpaSpecificationExecutor<DataViewAuthHorizontalRelationEntity>
  {
  /**
   * 按照横向数据权限进行详情查询（包括关联信息），这里查询的是
   * @param authHorizontal 横向数据权限
   * */
  @Query("select distinct dataViewAuthHorizontalRelationEntity from DataViewAuthHorizontalRelationEntity dataViewAuthHorizontalRelationEntity "
      + " left join fetch dataViewAuthHorizontalRelationEntity.authHorizontal dataViewAuthHorizontalRelationEntity_authHorizontal "
       + " where dataViewAuthHorizontalRelationEntity_authHorizontal.id = :authHorizontal")
  public Set<DataViewAuthHorizontalRelationEntity> findDetailsByAuthHorizontal(@Param("authHorizontal") String authHorizontal);

  /**
   * 按照主键进行详情查询（包括关联信息），这里查询的是
   * @param id 主键
   * */
  @Query("select distinct dataViewAuthHorizontalRelationEntity from DataViewAuthHorizontalRelationEntity dataViewAuthHorizontalRelationEntity "
      + " left join fetch dataViewAuthHorizontalRelationEntity.authHorizontal dataViewAuthHorizontalRelationEntity_authHorizontal "
      + " where dataViewAuthHorizontalRelationEntity.id=:id ")
  public DataViewAuthHorizontalRelationEntity findDetailsById(@Param("id") String id);

  /**
   * 按照横向权限ID删除
   * @param authHorizontalId
   */
  @Modifying
  @Query(value = "delete from engine_dataview_auth_horizontal_relation where auth_horizontal = :authHorizontalId",nativeQuery = true)
  public void deleteByAuthHorizontal(@Param("authHorizontalId") String authHorizontalId);

}