package com.bizunited.platform.core.repository.dataview;

import com.bizunited.platform.core.entity.DataViewFieldEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import java.util.List;

/**
 * DataViewFieldEntity业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_DataViewFieldRepository")
public interface DataViewFieldRepository
    extends
      JpaRepository<DataViewFieldEntity, String>
      ,JpaSpecificationExecutor<DataViewFieldEntity>
  {
  /**
   * 按照对应的视图进行查询
   * @param dataViewId 对应的视图
   */
  @Query("from DataViewFieldEntity dataViewFieldEntity " 
      + " left join fetch dataViewFieldEntity.dataView dataView " 
      + " where dataView.id = :dataViewId")
  public List<DataViewFieldEntity> findByDataView(@Param("dataViewId") String dataViewId);

  /**
   * 按照主键进行详情查询（包括关联信息），这里查询的是
   * @param id 主键
   * */
  @Query("select distinct dataViewFieldEntity from DataViewFieldEntity dataViewFieldEntity "
      + " left join  fetch dataViewFieldEntity.dataView dataViewFieldEntity_dataView "
      + " where dataViewFieldEntity.id=:id ")
  public DataViewFieldEntity findDetailsById(@Param("id") String id);

  
  @Modifying
  @Query("delete from DataViewFieldEntity field where field.id = :id")
  public void deleteById(@Param("id") String id);


    /**
     * find by code
     * @param code
     * @return
     */
  DataViewFieldEntity findByCode(String code);

}