package com.bizunited.platform.core.repository.dataview;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.repository.dataview.analysis.SqlAnalysis;
import com.bizunited.platform.core.service.dataview.model.SQLParamModel;
import com.bizunited.platform.core.service.invoke.model.InvokeParams;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository("DataViewRepositoryCustom")
public interface DataViewRepositoryCustom {
  /**
   * 根据设置的视图唯一键标识，和前端传入的唯一键标识的值，重新获取视图的数据信息
   * 回显数据功能
   * @param dataViewEntity
   * @param invokeParams
   * @param presets
   * @param primaryKey
   * @param primaryValue
   * @return
   */
  public JSONArray executeSQLEcho(DataViewEntity dataViewEntity, InvokeParams invokeParams, Map<String,Object>  presets, String primaryKey, JSONArray primaryValue);

  /**
   * 主数据源执行sql逻辑，但是只返回一条记录
   * @param sqlAnalysis
   * @return
   */
  public JSONArray executeSQLTop1(SqlAnalysis sqlAnalysis);

  /**
   * 使用本本进程的主数据源进行数据视图中设定的最原始SQL的保存。其它操作特性请参见:</br>
   * executeResource(String dataSourceCode , DataViewEntity dataView)方法
   * @param dataView
   * @return
   */
  DataViewEntity executeResource(DataViewEntity dataView);
  /**
   * 主数据源执行sql逻辑
   * @param sqlAnalysis
   * @return
   */
  public JSONArray executeSQL(SqlAnalysis sqlAnalysis);
  /**
   * 主数据源执行sql分页逻辑
   * @param sqlAnalysis
   * @return
   */
  Page<JSONObject> executeSQLPageAble(SqlAnalysis sqlAnalysis);

  /**
   * 验证主数据库中该表是否存在
   * @param tableName
   * @return
   */
  void checkTable(String tableName);

  public JSONArray executeSQLEcho(String sql , List<SQLParamModel> models);

  //======================以下是第三方========================

  /**
   * 第三方数据源执行sql逻辑，但是只返回一条记录
   * 使用原生jdbc语句执行查询，并获取ResultSetMetadata拿取列名称
   * @param dataSourceCode
   * @param sqlAnalysis
   * @return
   */
  public JSONArray executeSQLTop1(String dataSourceCode, SqlAnalysis sqlAnalysis);
  /**
   * 使用一个指定的第三方数据源，进行数据视图中设定的最原始SQL的预执行。预执行后，将向调用者返回执行后的SQL输出结构、以及要求填写的系统参数信息</br>
   * 注意，该方法只会对原始SQL进行执行（自动替换原始SQL中的系统参数信息），并不会将预执行后的结构做持久化保存；要进行持久化保存，请使用本服务中的creat方法
   * @param dataSourceCode 指定的第三方数据源
   * @param dataView 这个对象包括了数据视图最原始的SQL设定信息。
   * @return
   */
  DataViewEntity executeResource(String dataSourceCode, DataViewEntity dataView);
  /**
   * 第三方数据源执行sql逻辑
   * 使用原生jdbc语句执行查询，并获取ResultSetMetadata拿取列名称
   * @param dataSourceCode
   * @param dataView
   * @param sqlAnalysis
   * @return
   */
  public JSONArray executeSQL(String dataSourceCode, SqlAnalysis sqlAnalysis , DataViewEntity dataView);
  /**
   * 第三方数据源执行sql逻辑
   * 辨别数据库类型，使用原生jdbc语句执行分页查询，并获取ResultSetMetadata拿取列名称
   * @param dataSourceCode
   * @param sqlAnalysis
   * @param pageable
   * @return
   */
  public Page<JSONObject> executeSQLPageAble(String dataSourceCode, SqlAnalysis sqlAnalysis,Pageable pageable);

  /**
   * 检查第三方数据源中某张表是否存在
   * @param dataSourceCode
   * @param tableName
   */
  void checkTable(String dataSourceCode,String tableName);

  public JSONArray executeSQLEcho(String dataSourceCode,String sql , List<SQLParamModel> models);
}