package com.bizunited.platform.core.repository.dataview;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.entity.DataViewEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository("DataViewThirdDataSourceRepository")
public interface DataViewThirdDataSourceRepository {
  /**
   * 第三方数据源执行sql逻辑，但是只返回一条记录
   * 使用原生jdbc语句执行查询，并获取ResultSetMetadata拿取列名称
   * @param sql
   * @return
   */
  public JSONArray executeSQLTop1(String dataSourceCode, String sql);

  /**
   * 使用一个指定的第三方数据源，进行数据视图中设定的最原始SQL的预执行。预执行后，将向调用者返回执行后的SQL输出结构、以及要求填写的系统参数信息</br>
   * 注意，该方法只会对原始SQL进行执行（自动替换原始SQL中的系统参数信息），并不会将预执行后的结构做持久化保存；要进行持久化保存，请使用本服务中的creat方法
   * @param dataSourceCode 指定的第三方数据源
   * @param dataView 这个对象包括了数据视图最原始的SQL设定信息。
   * @return
   */
  DataViewEntity executeResource(String dataSourceCode, DataViewEntity dataView);
  /**
   * 第三方数据源执行sql逻辑
   * 使用原生jdbc语句执行查询，并获取ResultSetMetadata拿取列名称
   * @param sql
   * @return
   */
  public JSONArray executeSQL(String dataSourceCode, String sql);
  /**
   * 第三方数据源执行sql逻辑
   * 辨别数据库类型，使用原生jdbc语句执行分页查询，并获取ResultSetMetadata拿取列名称
   * @param sql
   * @return
   */
  public Page<JSONObject> executeSQLPageAble(String dataSourceCode, String sql, Pageable pageable);

  /**
   * 检查第三方数据源中某张表是否存在
   * @param dataSourceCode
   * @param tableName
   */
  void checkTable(String dataSourceCode, String tableName);
}
