package com.bizunited.platform.core.repository.dataview.analysis;

import java.util.Set;

import org.gradle.internal.impldep.com.google.common.collect.Sets;

/**
 * 静态变量
 * @Author: Paul Chan
 * @Date: 2019-10-09 17:26
 */
public class Constants {

  private Constants() {
    throw new IllegalStateException("静态对象不能被实例化！！");
  }

  /**空字符串*/
  public static final String EMPTY_CHAR = "";

  /**系统参数占位符表达式*/
  public static final String SYSTEM_PARAM_PATTERN = "\\{\\:[a-zA-Z]{1}\\w*\\}";

  /**参数SQL分析时，可能产生的别名*/
  public static final String ALIAS_STRING = "s01y01s01";

  /**参数SQL分析时，可能产生的别名*/
  public static final String ALIAS_STRING2 = "s02y02s02";

  /**参数SQL分析时，可能产生的别名*/
  public static final String ALIAS_STRING3 = "s03y03s03";

  /**五类权限类型：用户、用户组、组织机构、角色、岗位*/
  public static final Integer AUTH_TYPE_COUNT = 5;

  /**SQL占位符  默认是?传参，此种方式JPA和PrepareStatement都支持*/
  public static final String PLACE_HOLDER = "?";
  /**
   * 所有支持的类型都在这里
   */
  public static final Set<String> ALL_SUPPORT_CLASS = Sets.newHashSet("java.lang.String", "int", "java.lang.Integer", "double", "java.lang.Double",
      "float", "java.lang.Float", "long", "java.lang.Long", "short", "java.lang.Short", "byte", "java.lang.Byte", "boolean",
      "java.lang.Boolean", "char", "java.lang.Character", "java.util.Date", "java.math.BigDecimal");

}
