package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.common.enums.SQLCorrelationEnum;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.entity.DataViewFilterEntity;
import com.bizunited.platform.core.entity.DataViewSystemEntity;
import com.bizunited.platform.core.service.invoke.model.InvokeParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;

import java.util.Set;

import static com.bizunited.platform.core.repository.dataview.analysis.Constants.ALIAS_STRING2;
import static com.bizunited.platform.core.repository.dataview.analysis.Constants.ALIAS_STRING3;

/**
 * 实现oracle的sql分析，在执行sql前，对sql进行分页、参数、权限等处理
 *
 * @Author: Paul Chan
 * @Date: 2019-10-09 16:58
 */
public class OracleSqlAnalysis extends AbstractSqlAnalysis {


  public OracleSqlAnalysis(DataViewEntity dataView, Set<DataViewFilterEntity> filters, Set<DataViewSystemEntity> systemParams, Set<DataViewAuthHorizontalEntity> authHorizontals, Set<DataViewAuthVerticalEntity> authVerticals, InvokeParams params, Pageable pageable, Set<DataViewFieldEntity> allFileds) {
    super(dataView, filters, systemParams, authHorizontals, authVerticals, params, pageable, allFileds);
  }

  @Override
  public void analysis() {
    SQLAuthVerticalAnalysis.buildSQLAuthVertical(authVerticals, dataView.getSourceSql(), result, allFileds);
    String sql = result.get(SQLCorrelationEnum.RESULT_SQL).toString();
    SQLSystemParamAnalysis.buildSystemParamAnalysis(systemParams, params, result, sql);
    SQLConditionFilterAnalysis.buildSQLConditions(filters, result, params, this);
    SQLAuthHorizontalAnalysis.buildSQLAuthHorizoncal(authHorizontals, result);
    SQLOrderbyAnalysis.buildSQLConditionsOrderBy(filters, params, result);
    this.pageAnalysis();
  }

  /**
   * 分页处理
   */
  private void pageAnalysis() {
    if (pageable == null || CollectionUtils.isEmpty(result)) {
      return;
    }
    //两部分解析
    //1.先解析count语句
    String prePageSQL = result.remove(SQLCorrelationEnum.RESULT_SQL).toString();
    String countSQL = String.format("select count(*) from (%s) a", prePageSQL);
    result.putIfAbsent(SQLCorrelationEnum.PRE_ORDER_PAGE_SQL, countSQL);
    // 不包含开始行目
    int start = pageable.getPageNumber() * pageable.getPageSize();
    // 包含结束行目
    int end = (pageable.getPageNumber() + 1) * pageable.getPageSize();
    String pageSQL = String.format("select * from (select %s.*,ROWNUM RN from (%s) %s where ROWNUM <= %d) %s where RN > %d", ALIAS_STRING2, prePageSQL, ALIAS_STRING2, end, ALIAS_STRING3, start);
    result.put(SQLCorrelationEnum.RESULT_SQL, pageSQL);
  }

  @Override
  public String concatSql(String... strs) {
    if (strs == null || strs.length == 0) {
      return Constants.EMPTY_CHAR;
    }
    return StringUtils.join(strs, "||");
  }

}
