package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.common.enums.SQLCorrelationEnum;
import com.bizunited.platform.core.entity.DataViewFilterEntity;
import com.bizunited.platform.core.service.invoke.model.InvokeOperations;
import com.bizunited.platform.core.service.invoke.model.InvokeParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class SQLOrderbyAnalysis {
  /**
   * 通过私有构造函数，让该类暂时不对外开发
   * 因为后期可能会对该类进行重新设计
   */
  private SQLOrderbyAnalysis() {
  }

  /**
   * 解析orderBy情况
   *
   * @param filters
   * @param params
   */
  static void buildSQLConditionsOrderBy(Set<DataViewFilterEntity> filters, InvokeParams params, Map<SQLCorrelationEnum, Object> map) {
    if (CollectionUtils.isEmpty(filters) || CollectionUtils.isEmpty(map)) {
      return;
    }

    Set<DataViewFilterEntity> orderBySets = filters.stream().filter(e -> {
      String fieldName = e.getField().getFieldName();
      InvokeOperations model = params.get(fieldName);
      return params.containsKey(fieldName) && StringUtils.isNotBlank(model.getSortType());
    }).collect(Collectors.toSet());

    if (CollectionUtils.isEmpty(orderBySets)) {
      return;
    }

    StringBuilder orderByBuilder = new StringBuilder(" order by ");
    for (DataViewFilterEntity e : orderBySets) {
      String fieldName = e.getField().getFieldName();
      InvokeOperations model = params.get(fieldName);
      model.setOprtType(e.getOpType());
      model.setParamName(fieldName);
      orderByBuilder.append(String.format(" %s.%s %s,", Constants.ALIAS_STRING, model.getParamName(), model.getSortType()));
    }
    String orderBy = StringUtils.left(orderByBuilder.toString(), orderByBuilder.toString().length() - 1);
    String oldVal = map.remove(SQLCorrelationEnum.RESULT_SQL).toString();

    map.putIfAbsent(SQLCorrelationEnum.PRE_ORDER_PAGE_SQL, oldVal);
    String newVal = oldVal + orderBy;
    map.put(SQLCorrelationEnum.RESULT_SQL, newVal);
  }
}
