package com.bizunited.platform.core.repository.internal;

import java.util.List;
import java.util.Map;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.core.entity.CompetenceEntity;

@Repository("CompetenceRepositoryCustomImpl")
public class CompetenceRepositoryImpl implements CompetenceRepositoryCustom {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  private static final String COMMENT = "comment";
  
  /* (non-Javadoc)
   * @see com.bizunited.platform.kuiper.starter.repository.internal.CompetenceRepositoryCustom#queryPage(org.springframework.data.domain.Pageable, java.util.Map)
   */
  @SuppressWarnings("unchecked")
  @Override
  public Page<CompetenceEntity> queryPage(Pageable pageable, Map<String, Object> conditions) {
    /*
     * 目前的查询条件是：表单名、业务领域、项目名
     * */
    String hql = "from CompetenceEntity co where co.viewItem = 0 ";
    String countHql = "select count(*) from CompetenceEntity co where co.viewItem = 0 ";
    
    // 表单名name
    Object comment = conditions.get(COMMENT);
    if(comment != null) {
      hql += " AND co.comment = :comment ";
      countHql += " AND co.comment = :comment ";
    }
    hql += " order by co.sortIndex ";
    
    // 构造HQL查询 和 数量查询
    Query query = this.entityManager.createQuery(hql);
    Query countQuery = this.entityManager.createQuery(countHql);
    if(comment != null) {
      query.setParameter(COMMENT, comment);
      countQuery.setParameter(COMMENT, comment);
    }
    
    // 构造返回信息和最新的分页结果
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<CompetenceEntity> resutls = query.getResultList();
    // 查询总数量信息
    long count = (long)countQuery.getResultList().get(0);
    PageImpl<CompetenceEntity> currentPage = new PageImpl<>(resutls,pageable,count);
    return currentPage;
  }

}
