package com.bizunited.platform.core.repository.internal;

import com.bizunited.platform.core.entity.EnvironmentVariableEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.util.List;
import java.util.Map;

/**
 * EnvironmentVariableRepositoryImpl
 *
 * @description:
 * @author: yanwe
 * @date: 11/Jun/2019 10:43
 */
@Repository("EnvironmentVariableRepositoryImpl")
public class EnvironmentVariableRepositoryImpl implements EnvironmentVariableRepositoryCustom {
  @Autowired 
  @PersistenceContext 
  private EntityManager entityManager;
  private static final String PARAM_CODE = "paramCode";
  private static final String PARAM_KEY = "paramKey";
  private static final String PARAM_VALUE = "paramValue";
  private static final String PARAM_TYPE = "paramType";
  private static final String PARAM_STATUS = "paramStatus";
  @SuppressWarnings("unchecked")
  @Override
  public Page<EnvironmentVariableEntity> queryPage(
      Pageable pageable, Map<String, Object> conditions) {
    /*
     * 按照需求，是按照参数名称、参数键、参数值,参数类型,参数状态进行查询
     * */
    String hql =
        "from EnvironmentVariableEntity u left join fetch u.createUser left join fetch u.modifyUser where 1 = 1 ";
    String countHql = "select count(*) from EnvironmentVariableEntity u where 1 = 1 ";

    Object paramCode = conditions.get(PARAM_CODE);
    if (paramCode != null) {
      hql += " AND u.paramCode = :paramCode ";
      countHql += " AND u.paramCode = :paramCode ";
    }
    Object paramKey = conditions.get(PARAM_KEY);
    if (paramKey != null) {
      hql += " AND u.paramKey = :paramKey ";
      countHql += " AND u.paramKey = :paramKey ";
    }
    Object paramValue = conditions.get(PARAM_VALUE);
    if (paramValue != null) {
      hql += " AND u.paramValue = :paramValue ";
      countHql += " AND u.paramValue = :paramValue ";
    }
    Object paramType = conditions.get(PARAM_TYPE);
    if (paramType != null) {
      hql += " AND u.paramType = :paramType ";
      countHql += " AND u.paramType = :paramType ";
    }
    Object paramStatus = conditions.get(PARAM_STATUS);
    if (paramStatus != null) {
      hql += " AND u.paramStatus = :paramStatus ";
      countHql += " AND u.paramStatus = :paramStatus ";
    }

    hql += " order by u.createDate desc ";

    // 构造HQL查询 和 数量查询
    Query query = this.entityManager.createQuery(hql);
    Query countQuery = this.entityManager.createQuery(countHql);

    if (paramCode != null) {
      query.setParameter(PARAM_CODE, paramCode);
      countQuery.setParameter(PARAM_CODE, paramCode);
    }
    if (paramKey != null) {
      query.setParameter(PARAM_KEY, paramKey);
      countQuery.setParameter(PARAM_KEY, paramKey);
    }
    if (paramValue != null) {
      query.setParameter(PARAM_VALUE, paramValue);
      countQuery.setParameter(PARAM_VALUE, paramValue);
    }
    if (paramType != null) {
      query.setParameter(PARAM_TYPE, paramType);
      countQuery.setParameter(PARAM_TYPE, paramType);
    }
    if (paramStatus != null) {
      query.setParameter(PARAM_STATUS, paramStatus);
      countQuery.setParameter(PARAM_STATUS, paramStatus);
    }

    // 构造分页信息
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<EnvironmentVariableEntity> results = query.getResultList();
    // 查询总数量信息
    long count = (long) countQuery.getResultList().get(0);
    PageImpl<EnvironmentVariableEntity> currentPage = new PageImpl<>(results, pageable, count);
    return currentPage;
  }
}
