package com.bizunited.platform.core.repository.internal;

import com.bizunited.platform.core.entity.PositionEntity;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import java.util.List;
import java.util.Map;

/**
 * PositionRepositoryImpl
 *
 * @description:
 * @author: yanwe
 * @date: 18/Jan/2019 15:14
 */
@Repository("PositionRepositoryImpl")
public class PositionRepositoryImpl implements PositionRepositoryCustom {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  private static final String T_STATUS = "tstatus";

  @Override
  @SuppressWarnings("unchecked")
  public Page<PositionEntity> queryPage(Pageable pageable, Map<String, Object> conditions) {
    /*
     * 按照需求，是按照名称、编码、状态进行查询
     */
    String hql = "from PositionEntity u left join fetch u.roles left join fetch u.users left join fetch u.organization where 1 = 1";
    String countHql = "select count(*) from PositionEntity u where 1 = 1";
    Object name = conditions.get("name");
    if (name != null) {
      hql += " AND u.name = :name ";
      countHql += " AND u.name = :name ";
    }
    Object code = conditions.get("code");
    if (code != null) {
      hql += " AND u.code = :code ";
      countHql += " AND u.code = :code ";
    }
    Object tstatus = conditions.get(T_STATUS);
    if (tstatus != null) {
      hql += " AND u.tstatus = :tstatus ";
      countHql += " AND u.tstatus = :tstatus ";
    }
    hql += " order by u.createTime desc ";

    // 构造HQL查询 和 数量查询
    Query query = this.entityManager.createQuery(hql);
    Query countQuery = this.entityManager.createQuery(countHql);
    if (name != null) {
      query.setParameter("name", name);
      countQuery.setParameter("name", name);
    }
    if (code != null) {
      query.setParameter("code", code);
      countQuery.setParameter("code", code);
    }
    if (tstatus != null) {
      query.setParameter(T_STATUS, tstatus);
      countQuery.setParameter(T_STATUS, tstatus);
    }

    // 构造分页信息
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<PositionEntity> results = query.getResultList();

    // 查询总数量信息
    long count = (long) countQuery.getResultList().get(0);
    PageImpl<PositionEntity> currentPage = new PageImpl<>(results, pageable, count);
    return currentPage;
  }
}
