package com.bizunited.platform.core.repository.internal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.core.entity.RemoteServiceAddressEntity;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import java.util.HashMap;
import java.util.Map;

/**
 * RemoteServiceAddressRepositoryImpl
 * @description:
 * @author: yanwe
 * @date: 06/May/2019 10:12
 */
@Repository("RemoteServiceAddressRepositoryImpl")
public class RemoteServiceAddressRepositoryImpl implements RemoteServiceAddressRepositoryCustom, BaseRepositoryImpl {

  @Autowired 
  @PersistenceContext 
  private EntityManager entityManager;
  private static final String ALIAS = "alias";
  private static final String CODE = "code";

  /* (non-Javadoc)
   * @see com.bizunited.platform.kuiper.starter.repository.internal.RemoteServiceAddressRepositoryCustom#queryPage(org.springframework.data.domain.Pageable, java.util.Map)
   */
  @Override
  public Page<RemoteServiceAddressEntity> findByConditions(Pageable pageable, Map<String, Object> conditions) {
    StringBuilder hql = new StringBuilder("from RemoteServiceAddressEntity u  where 1 = 1");
    StringBuilder countHql = new StringBuilder("select count(*) from RemoteServiceAddressEntity u where 1 = 1");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameter = new HashMap<>(4);
    Object code = conditions.get(CODE);
    if (code != null) {
      condition.append(" AND u.code = :code ");
      parameter.put("code", code);
    }
    Object alias = conditions.get(ALIAS);
    if (alias != null) {
      condition.append(" AND u.alias = :alias ");
      parameter.put("alias", alias);
    }
    hql.append(condition);
    countHql.append(condition);
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameter, pageable);
  }
}
