package com.bizunited.platform.core.repository.internal;

import com.bizunited.platform.core.entity.ScriptEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.util.List;
import java.util.Map;

@Repository("ScriptRepositoryImpl")
public class ScriptRepositoryImpl implements ScriptRepositoryCustom {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  private static final String MESS_LANGUAGE = "language";
  private static final String MESS_NAME = "name";

  @SuppressWarnings("unchecked")
  @Override
  public Page<ScriptEntity> queryPage(Pageable pageable, Map<String, Object> conditions) {

    /*
     * -目前的查询条件是：表单名、业务领域、项目名
     * */
    String hql = "from ScriptEntity script where 1=1 ";
    String countHql = "select count(*) from ScriptEntity script where 1=1 ";

    // 表单名name
    Object name = conditions.get(MESS_NAME);
    if(name != null) {
      hql += " AND script.name = :name ";
      countHql += " AND script.name = :name ";
    }

    // 表单名name
    Object language = conditions.get(MESS_LANGUAGE);
    if(language != null) {
      hql += " AND script.language = :language ";
      countHql += " AND script.language = :language ";
    }

    // 构造HQL查询 和 数量查询
    Query query = this.entityManager.createQuery(hql);
    Query countQuery = this.entityManager.createQuery(countHql);
    if(name != null) {
      query.setParameter(MESS_NAME, name);
      countQuery.setParameter(MESS_NAME, name);
    }
    if(language != null) {
      query.setParameter(MESS_LANGUAGE, language);
      countQuery.setParameter(MESS_LANGUAGE, language);
    }

    // 构造返回信息和最新的分页结果
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<ScriptEntity> results = query.getResultList();
    // 查询总数量信息
    long count = (long)countQuery.getResultList().get(0);
    PageImpl<ScriptEntity> currentPage = new PageImpl<>(results,pageable,count);
    return currentPage;
  }
}
