package com.bizunited.platform.core.repository.internal;

import java.util.List;
import java.util.Map;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.core.entity.UserEntity;

/**
 * @author yinwenjie
 */
@Repository("UserRepositoryImpl")
public class UserRepositoryImpl implements UserRepositoryCustom {
  
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  private static final String USER_NAME = "userName";
  private static final String ACCOUNT = "account";
  private static final String USE_STATUS = "useStatus";

  /* (non-Javadoc)
   * @see com.bizunited.platform.kuiper.starter.repository.internal.UserRepositoryCustom#queryPage(org.springframework.data.domain.Pageable, java.util.Map)
   */
  @Override
  @SuppressWarnings("unchecked")
  public Page<UserEntity> queryPage(Pageable pageable, Map<String, Object> conditions) {
    /*
     * 按照需求，是按照人员姓名或者账号信息进行查询
     * */
    String hql = "from UserEntity u left join fetch u.roles where 1 = 1";
    String countHql = "select count(*) from UserEntity u where 1 = 1";
    Object userName = conditions.get(USER_NAME);
    if(userName != null) {
      hql += " AND u.userName = :userName ";
      countHql += " AND u.userName = :userName ";
    }
    Object account = conditions.get(ACCOUNT);
    if(account != null) {
      hql += " AND u.account = :account ";
      countHql += " AND u.account = :account ";
    }
    Object useStatus = conditions.get(USE_STATUS);
    if (useStatus != null) {
      hql += " AND u.useStatus = :useStatus ";
      countHql += " AND u.useStatus = :useStatus ";
    }
    hql += " order by u.createTime desc ";
    
    // 构造HQL查询 和 数量查询
    Query query = this.entityManager.createQuery(hql);
    Query countQuery = this.entityManager.createQuery(countHql);
    if(userName != null) {
      query.setParameter(USER_NAME, userName);
      countQuery.setParameter(USER_NAME, userName);
    }
    if(account != null) {
      query.setParameter(ACCOUNT, account);
      countQuery.setParameter(ACCOUNT, account);
    }
    if (useStatus != null) {
      query.setParameter(USE_STATUS, useStatus);
      countQuery.setParameter(USE_STATUS, useStatus);
    }
    
    // 构造分页信息
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<UserEntity> resutls = query.getResultList();
    
    // 查询总数量信息
    long count = (long)countQuery.getResultList().get(0);
    PageImpl<UserEntity> currentPage = new PageImpl<>(resutls,pageable,count);
    return currentPage;
  } 
}