package com.bizunited.platform.core.service;

import com.bizunited.platform.core.entity.CodeRuleEntity;

import java.util.Set;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

/**
 * CodeRuleService
 *
 * @description: 业务编码规则的服务定义
 * @author: yanwe 
 * @date: 12/Jun/2019 15:22
 */
public interface CodeRuleService {
  /**
   * 新增编码生成规则基础属性
   * @param entity
   * @return
   */
  CodeRuleEntity create(CodeRuleEntity entity);

  /**
   * 更新编码生成规则基础属性
   * @param entity
   * @return
   */
  CodeRuleEntity update(CodeRuleEntity entity);
  /**
   * 更新编码生成规则的脚本
   * @param ruleId
   * @param content
   * @return
   */
  CodeRuleEntity updateContent(String ruleId, String content);
  /**
   * 根据规则生成编码
   * @param ruleCode
   * @return
   */
  String invoke(String ruleCode);
  /**
   * 根据编码生成规则的编号查询脚本内容
   * @param ruleId
   * @return
   */
  String findContentByCode(String code); 
  /**
   * 根据条件分页查询
   * @param pageable
   * @param ruleName
   * @param ruleCode
   * @param ruleType
   * @param language
   * @return
   */
  Page<CodeRuleEntity> findByConditions(Pageable pageable, String ruleName, String ruleCode, String ruleType, String language);
  /**
   * 根据编码生成规则的多个ID查询脚本内容，查询基本信息和所有关联信息
   * @param ids
   * @return
   */
  Set<CodeRuleEntity> findDetailsByIds(String[] ids);
  /**
   * 按照指定的业务编码规则的ID信息，查询最终满足这些id编号的数据条目。<br>
   * 这个方法一般用于验证一批给定的id，是否都能在系统中找到对应的数据
   * @param ids 指定的id信息
   * @return 满足的条目数量将会被返回
   */
  int countByIds(String[] ids);


  /**
   * 根据ruleCode查询
   * @param ruleCode
   * @return
   */
  CodeRuleEntity findByRuleCode(String ruleCode);

  /**
   * 根据ruleName查询
   * @param ruleName
   * @return
   */
  CodeRuleEntity findByRuleName(String ruleName);

}
