package com.bizunited.platform.core.service;

import com.bizunited.platform.core.entity.DictCategoryEntity;

import java.util.Set;

/**
 * DictCategoryService
 *
 * @description: 数据字典分类信息服务
 * @author: yanwe
 * @date: 11/Jun/2019 17:32
 */
public interface DictCategoryService {
  /**
   * 新增一个字典分组
   * @param dictCategoryEntity 字典信息
   * @param parentId 父类分组ID，如为顶级，则可为空
   * @return
   */
  DictCategoryEntity create(DictCategoryEntity dictCategoryEntity,String parentId);
  /**
   * 更新一个字典分组
   * @param dictCategoryEntity
   * @return
   */
  DictCategoryEntity update(DictCategoryEntity dictCategoryEntity);
  /**
   * 将两个字典分组列为父子级关系
   * @param childId 将要作为子级的字典分组ID
   * @param parentId 将要作为父级的字典分组ID, 如果为空，则设置子级字典为根级
   */
  void bind(String childId,String parentId);
  /**
   * 查询所有,并以树形结构列出
   * @return
   */
  Set<DictCategoryEntity> findAll();
  /**
   * 根据id查询基本信息，没有任何关联信息
   * @param id
   * @return
   */
  DictCategoryEntity findById(String id);
  /**
   * 根据id查询字典分类的基本信息和关联信息（但是不包括字典分类的子级集合关联）
   * @param id
   * @return
   */
  DictCategoryEntity findDetailsById(String id);
  
  /**
   * 根据数据字典业务编号code进行查询，不包括任何关联信息
   * @param code 业务编号code在全系统唯一
   * @return
   */
  DictCategoryEntity findByCode(String code);
}