package com.bizunited.platform.core.service;

import com.bizunited.platform.core.entity.DictItemEntity;

import java.util.List;

/**
 * DictItemService
 *
 * @description:
 * @author: yanwe
 * @date: 11/Feb/2019 10:32
 */
public interface DictItemService {

  /**
   * 根据字典编码查询所有子项
   *
   * @param dictCode
   * @return
   */
  List<DictItemEntity> findItemsByCode(String dictCode);

  /**
   * 为字典类 修改/添加/删除 明细
   *
   * @param dictCode
   * @param items
   * @return
   */
  List<DictItemEntity> updateItems(String dictCode, List<DictItemEntity> items);

  /**
   * 启用单个明细
   * @param dictItemId
   * @return
   */
  DictItemEntity enable(String dictItemId);

  /**
   * 禁用单个明细
   * @param dictItemId
   * @return
   */
  DictItemEntity disable(String dictItemId);
}
