package com.bizunited.platform.core.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bizunited.platform.core.entity.RemoteServiceEntity;

import java.util.Set;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

/**
 * RemoteServiceService
 *
 * @description:
 * @author: yanwe
 * @date: 05/May/2019 11:26
 */
public interface RemoteServiceService {
  /**
   * 测试/执行 远端服务源连接，获取返回值
   *
   * @param remoteServiceEntity 服务源基础信息，保存于数据库
   * @param json 服务源参数信息，保存于本地
   * @return 将调用服务返回的值，直接返还接口调用的值，拼接成前端要求的json格式
   */
  JSON valid(String remoteServiceEntity, String json);
  /**
   * 新增远端服务源
   *
   * @param remoteServiceEntity 服务源基础信息，保存于数据库
   * @param jsonStr 服务源参数信息，保存于本地
   * @return
   */
  RemoteServiceEntity create(String remoteServiceEntity, String jsonStr);


  /**
   * 新增远端服务源，仅仅保存实体，不做验证，用于迁移
   *
   * @param remoteServiceEntity 服务源基础信息，保存于数据库
   * @return
   */
  RemoteServiceEntity create(RemoteServiceEntity remoteServiceEntity);
  /**
   * 修改远端服务源
   *
   * @param remoteServiceEntity 服务源基础信息，保存于数据库
   * @param json 服务源参数信息，保存于本地
   * @return
   */
  RemoteServiceEntity update(String remoteServiceEntity, String json);
  /**
   * 禁用
   * 
   * @param remoteServiceId
   * @return
   */
  RemoteServiceEntity disable(String remoteServiceId);
  /**
   * 根据用户输入JSON导出前端JSON结构
   * 
   * @param json
   * @return
   */
  JSONArray importJson(String json);
  /**
   * 执行 远端服务源连接，获取返回值
   * @param code 服务源唯一的业务编号
   * @param json
   * @return
   */
  JSON execute(String code, String json);
  /**
   * 根据业务编号查询保存在文件中的格式JSON，注意这个json信息是包括head信息、请求参数设定等的完整信息
   * @param code 系统唯一的业务编号信息
   * @return
   */
  JSON findCompleteByCode(String code);
  /**
   * 获取草稿，按照业务编号。注意这个json中的信息不回包括head、请求参数设定等信息
   * @param code 系统唯一的业务编号信息
   * @return
   */
  String findJsonByCode(String code);


  /**
   * 根据编码查询
   * @param code
   * @return
   */
  RemoteServiceEntity findByCode(String code);
  /**
   * 根据一个或者多个远端服务源的ID信息，查询其基本信息和关联信息
   * @param remoteServiceIds 
   * @return
   */
  Set<RemoteServiceEntity> findDetailsByIds(String[] remoteServiceIds); 
  /**
   * 分页查询
   *
   * @param remoteServiceType 远端服务源类型（
   *   0:自定义HTTP调用地址; 
   *   1:client形式的spring cloud; 
   *   2: 非client形式的spring cloud）
   * @param addressCode 地址编码
   * @param addressAlias 地址别名
   * @param requestMethod 请求方式
   * @return
   */
  Page<RemoteServiceEntity> findByConditions(Integer remoteServiceType, String addressCode, String addressAlias, String requestMethod,Integer remoteServiceStatus, Pageable pageable);
  /**
   * 按照指定的远端调用源的ID信息，查询最终满足这些id编号的数据条目。<br>
   * 这个方法一般用于验证一批给定的id，是否都能在系统中找到对应的数据
   * @param ids 指定的id信息
   * @return 满足的条目数量将会被返回
   */
  int countByIds(String[] ids);
}
