package com.bizunited.platform.core.service.dataview;

import com.bizunited.platform.core.entity.DataViewAuthVerticalRelationEntity;

import java.lang.String;
import java.util.Set;

/**
 * 纵向权限选定的权限关系集DataViewAuthVerticalRelationEntity业务模型的服务层接口定义
 * @author saturn
 */
public interface DataViewAuthVerticalRelationService {

  /**
   * 创建纵向权限选定的权限关系集时校验数据
   * @param dataViewAuthVerticalRelationEntity
   */
  public void createValidation(DataViewAuthVerticalRelationEntity dataViewAuthVerticalRelationEntity);

  /**
   * 更新纵向权限选定的权限关系集时校验数据
   * @param dataViewAuthVerticalRelationEntity
   */
  public void updateValidation(DataViewAuthVerticalRelationEntity dataViewAuthVerticalRelationEntity);


  /**
   * 按照关联的 纵向数据权限进行详情查询（包括关联信息）
   * @param authVertical 关联的 纵向数据权限
   */
  public Set<DataViewAuthVerticalRelationEntity> findDetailsByAuthVertical(String authVertical);
  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   */
  public DataViewAuthVerticalRelationEntity findDetailsById(String id);
  /**
   * 按照DataViewAuthVerticalRelationEntity的主键编号，查询指定的数据信息（不包括任何关联信息）
   * @param id 主键
   * */
  public DataViewAuthVerticalRelationEntity findById(String id);
  /**
   *  按照主键进行信息的真删除 
   * @param id 主键 
   */
  public void deleteById(String id);
}