package com.bizunited.platform.core.service.dataview.internal;

import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import com.bizunited.platform.core.entity.DataViewAuthVerticalRelationEntity;
import com.bizunited.platform.core.repository.dataview.DataViewAuthVerticalRelationRepository;
import com.bizunited.platform.core.service.dataview.DataViewAuthVerticalRelationService;
import com.google.common.collect.Sets;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.util.Optional;
import java.util.Set;

/**
 * DataViewAuthVerticalRelationEntity业务模型的服务层接口实现
 * @author saturn
 */
@Service("DataViewAuthVerticalRelationServiceImpl")
public class DataViewAuthVerticalRelationServiceImpl implements DataViewAuthVerticalRelationService {
  @Autowired
  private DataViewAuthVerticalRelationRepository dataViewAuthVerticalRelationRepository;
  /**
   * 在创建一个新的DataViewAuthVerticalRelationEntity模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  public void createValidation(DataViewAuthVerticalRelationEntity dataViewAuthVerticalRelationEntity) {
    Validate.notNull(dataViewAuthVerticalRelationEntity , "权限领域信息必须传入!!");
    // 判定那些不能为null的输入值：条件为 caninsert = true，且nullable = false
    Validate.isTrue(StringUtils.isBlank(dataViewAuthVerticalRelationEntity.getId()), "添加权限领域时，（主键）不能有值！");
    dataViewAuthVerticalRelationEntity.setId(null);

    DataViewAuthVerticalEntity authVertical = dataViewAuthVerticalRelationEntity.getAuthVertical();
    Validate.notNull(authVertical,"传入的纵向权限对象不能为空，请检查!!");

    Validate.notBlank(dataViewAuthVerticalRelationEntity.getAuthRelationIds(), "权限领域信息不能为空！");
    Validate.notNull(dataViewAuthVerticalRelationEntity.getSortIndex(),"排序信息不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK （注意连续空字符串的情况） 
    Validate.isTrue(dataViewAuthVerticalRelationEntity.getAuthRelationIds() == null || dataViewAuthVerticalRelationEntity.getAuthRelationIds().length() < 255 , "权限关系集,填入值超过了限定长度(255)，请检查!");
  }


  /**
   * 在更新一个已有的DataViewAuthVerticalRelationEntity模型对象之前，该私有方法检查对象各属性的正确性，其id属性必须有值
   */
  public void updateValidation(DataViewAuthVerticalRelationEntity dataViewAuthVerticalRelationEntity) {
    Validate.isTrue(!StringUtils.isBlank(dataViewAuthVerticalRelationEntity.getId()), "修改权限领域信息时，（主键）必须有值！");

    DataViewAuthVerticalEntity authVertical = dataViewAuthVerticalRelationEntity.getAuthVertical();
    Validate.notNull(authVertical,"传入的纵向权限对象不能为空，请检查!!");

    // 基础信息判断，基本属性，需要满足not null
    Validate.notBlank(dataViewAuthVerticalRelationEntity.getAuthRelationIds(), "权限领域不能为空！");
    Validate.notNull(dataViewAuthVerticalRelationEntity.getSortIndex(),"排序信息不能为空！");

    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK，且canupdate = true
    Validate.isTrue(dataViewAuthVerticalRelationEntity.getAuthRelationIds() == null || dataViewAuthVerticalRelationEntity.getAuthRelationIds().length() < 255 , "权限关系集,填入值超过了限定长度(255)，请检查!");
    
  }
  @Override
  public Set<DataViewAuthVerticalRelationEntity> findDetailsByAuthVertical(String authVertical) { 
    if(StringUtils.isBlank(authVertical)) { 
      return Sets.newHashSet();
    }
    return this.dataViewAuthVerticalRelationRepository.findDetailsByAuthVertical(authVertical);
  }
  @Override
  public DataViewAuthVerticalRelationEntity findDetailsById(String id) { 
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    return this.dataViewAuthVerticalRelationRepository.findDetailsById(id);
  }
  @Override
  public DataViewAuthVerticalRelationEntity findById(String id) { 
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    Optional<DataViewAuthVerticalRelationEntity> op = this.dataViewAuthVerticalRelationRepository.findById(id);
    return op.orElse(null);
  }
  @Override
  @Transactional
  public void deleteById(String id) {
    // 只有存在才进行删除
    Validate.notBlank(id , "进行删除时，必须给定主键信息!!");
    Optional<DataViewAuthVerticalRelationEntity> op = this.dataViewAuthVerticalRelationRepository.findById(id);
    op.ifPresent(dataViewAuthVerticalRelationEntity -> this.dataViewAuthVerticalRelationRepository.delete(dataViewAuthVerticalRelationEntity));
  }
} 
