package com.bizunited.platform.core.service.image;

import java.io.IOException;

import com.bizunited.platform.core.entity.OrdinaryFileEntity;

public interface FileViewService {
  /**
   * 通过文件相对路径查询指定的图片信息——支持特效参数
   * @param folder 图片所在目录
   * @param imageFile 图片名
   * @param prefix 图片后缀
   * @param special 指定的特效信息<br>
   * 这个方法测试有参数的图片访问方式<br/>
   * 这里留了几个测试参数：<br/>
   * ?special=zoomimage%7Cwidth%3D300%7Cheight%3D300->markimage%7CmarkValue%3Dwwwyinwenjienet.222<br/>
   * ?special=zoomimage%7Cratio%3D0.1->markimage%7CmarkValue%3Dwww.yinwenjie.net<br/>
   * ?special=cutimage%7Cratio%3D0.1->markimage%7CmarkValue%3Dwww.yinwenjie.net<br/>
   * ?special=cutimage%7Cwidth%3D300%7Cheight%3D300->markimage%7CmarkValue%3Dwww.yinwenjie.net<br/>
   * @throws IllegalArgumentException
   * @throws IOException
   */
  public byte[] imageQuery(String folder , String imageFile , String prefix , String special) throws IllegalArgumentException , IOException;

  /**
   * 更具一般文件（非图片文件）查询指定文件内容
   * @param relativeLocal 文件路径
   * @param fileName  文件名
   * @throws IllegalArgumentException
   * @throws IOException
   */
  public byte[] fileQuery(String relativeLocal, String fileName) throws IllegalArgumentException, IOException;
  /**
   * 根据文件名和路径查询文件信息
   * @param fileName
   * @param relativeLocal
   * @return
   */
  OrdinaryFileEntity findByFileNameAndRelativeLocal(String fileName, String relativeLocal);
}
