package com.bizunited.platform.core.service.init;

import javax.transaction.Transactional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.bizunited.platform.core.repository.dynamic.DynamicDataSourceManager;

/**
 * 该方法在应用程序启动时，初始化当前系统已经设定的，且状态正常的第三方数据源信息
 * @author yinwenjie
 */
@Component("DynamicDataSourceProcess")
public class DynamicDataSourceInitProcess implements InitProcessService {
  @Autowired
  private DynamicDataSourceManager dynamicDataSourceManager;
  
  @Override
  public boolean doProcess() {
    return true;
  }

  @Override
  public int sort() {
    // 初始化动作靠前
    return 6;
  }

  @Override
  @Transactional
  public void init() {
    dynamicDataSourceManager.init();
  }
}