package com.bizunited.platform.core.service.init;

/**
 * 系统初始化服务接口：在nebula以及基于nebula建设的业务系统中，会涉及到各种系统初始化过程，例如：</br>
 * 流程引擎子系统需要进行的平台上下文（PlatformContext）属性设定的初始化过程；平台基础工具套件需要进行的角色信息初始化；
 * 以及诸如“订单”子系统这样的业务系统需要进行的“渠道基本信息”初始化动作等</p>
 * 那么该接口就是为了规范整个初始化过程，避免各种不同的初始化动作“粘连”在一起
 * @author yinwenjie
 */
public interface InitProcessService {
  
  static final int DEFAULT_SORT = Integer.MAX_VALUE; 
  
  /**
   * 该方法返回的值，将决定当前这个初始化过程的执行顺序，返回值越小当前执行过程就越靠前
   * @return 默认返回Integer.MAX_VALUE
   */
  public default int sort() {
    return DEFAULT_SORT;
  }
  
  /**
   * 有的初始化过程并不是每次进程启动都要进行的，例如平台基础工具套件在进行角色初始化时，只需要在第一次进程启动时进行；</p>
   * 所以初始化动作需要该方法进行控制，如果返回true则表示本次进行启动时，需要进行初始化；其它情况则表示不需要运行初始化动作
   */
  public boolean doProcess();
  
  /**
   * 该方法指示，当这个初始化过程发生异常时，是否终止整个进程的启动过程
   * @return 返回false的时候，即使该初始化过程抛出了异常，也不会终止进程的启动过程，系统还将处理下一个初始化过程；如果返回true，则表示同样情况出现时，终止整个系统的启动过程
   */
  public default boolean stopOnException() {
    return false;
  }
  /**
   * 每一个具体的初始化动作，都需要实现该方法
   */
  public void init();
}
