package com.bizunited.platform.core.service.internal;

import com.bizunited.platform.core.entity.DictEntity;
import com.bizunited.platform.core.entity.DictItemEntity;
import com.bizunited.platform.core.repository.DictItemRepository;
import com.bizunited.platform.core.repository.DictRepository;
import com.bizunited.platform.core.service.DictItemService;
import com.google.common.collect.Lists;

import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service("DictItemServiceImpl")
public class DictItemServiceImpl implements DictItemService {

  private static final String ERROR_MESS = "字典明细ID不能为空！";
  @Autowired 
  private DictRepository dictRepository;
  @Autowired 
  private DictItemRepository dictItemRepository;

  @Override
  public List<DictItemEntity> findItemsByCode(String dictCode) {
    DictEntity dictEntity = dictRepository.findByDictCode(dictCode);
    if (dictEntity == null) {
      return Lists.newArrayList();
    }
    List<DictItemEntity> itmes = dictItemRepository.findByDictEntityOrderByDictSort(dictEntity);
    return itmes;
  }

  @Override
  @Transactional
  public List<DictItemEntity> updateItems(String dictCode, List<DictItemEntity> items) {
    Validate.notBlank(dictCode, "查询字典编码不能为空！");
    DictEntity dictEntity = dictRepository.findByDictCode(dictCode);
    Validate.notNull(dictEntity, "未找到该编码匹配字典！");
    Validate.isTrue(!dictEntity.getDictStatus(), "该字典已经上架，无法再修改明细项");
    if(items==null){
      items = new ArrayList<>();
    }else {
      //判断添加的子项里面是否有重复的KEY或者VALUE
      List<String> keys = items.stream().map(o -> o.getDictKey()).distinct().collect(Collectors.toList());
      List<String> values = items.stream().map(o -> o.getDictValue()).distinct().collect(Collectors.toList());
      Boolean hasSame = (keys.size()<items.size()||(values.size()<items.size()));
      Validate.isTrue(!hasSame,"包含重复的key或者value!");
    }
    List<DictItemEntity> oldItems = dictItemRepository.findByDictEntity(dictEntity);
    dictEntity.setItemNum(items.size());
    dictEntity.setDictItemEntities(null);
    dictRepository.saveAndFlush(dictEntity);
    dictItemRepository.deleteAll(oldItems);
    dictItemRepository.flush();

    items.stream()
        .forEach(
            o -> {
              o.setId(null);
              o.setDictSort(null == o.getDictSort() ? 1 : o.getDictSort());
              o.setDictEntity(dictEntity);
            });
    dictItemRepository.saveAll(items);

    return items;
  }

  @Override
  @Transactional
  public DictItemEntity enable(String dictItemId) {
    Validate.notBlank(dictItemId,ERROR_MESS);
    DictItemEntity dictItemEntity = dictItemRepository.findDetailById(dictItemId);
    Validate.notNull(dictItemEntity,ERROR_MESS);
    dictItemEntity.setDictItemStatus(true);
    return dictItemRepository.save(dictItemEntity);
  }

  @Override
  @Transactional
  public DictItemEntity disable(String dictItemId) {
    Validate.notBlank(dictItemId,ERROR_MESS);
    DictItemEntity dictItemEntity = dictItemRepository.findDetailById(dictItemId);
    Validate.notNull(dictItemEntity,ERROR_MESS);
    dictItemEntity.setDictItemStatus(false);
    return dictItemRepository.save(dictItemEntity);
  }
}
