package com.bizunited.platform.core.service.internal;

import com.bizunited.platform.core.service.NebulaStaticPersistentService;
import com.bizunited.platform.saturn.context.SaturnContext;
import com.bizunited.platform.saturn.context.service.PersistentClassService;
import com.bizunited.platform.saturn.context.service.PersistentPropertyService;
import com.bizunited.platform.saturn.context.service.PersistentRelationService;
import com.bizunited.platform.saturn.model.PersistentClass;
import com.bizunited.platform.saturn.model.PersistentProperty;
import com.bizunited.platform.saturn.model.PersistentRelation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service("KuiperStaticPersistentServiceImpl")
public class NebulaStaticPersistentServiceImpl implements NebulaStaticPersistentService {

  @Autowired
  private SaturnContext saturnContext;
  
  /* (non-Javadoc)
 * @see com.bizunited.platform.core.service.NebulaStaticPersistentService#findAllPersistentClasses()
 */
@Override
  public List<PersistentClass> findAllPersistentClasses() {
    PersistentClassService persistentClassService = this.saturnContext.getPersistentClassService();
    return persistentClassService.queryAllClasses();
  }
  
  /* (non-Javadoc)
   * @see com.bizunited.platform.core.service.NebulaStaticPersistentService#findAllMainPersistentClasses()
   */
  @Override
  public List<PersistentClass> findAllMainPersistentClasses() {
    PersistentClassService persistentClassService = this.saturnContext.getPersistentClassService();
    List<PersistentClass> persistentClasses = persistentClassService.queryAllClasses();
    if(persistentClasses == null || persistentClasses.isEmpty()) {
      return null;
    }
    
    persistentClasses = persistentClasses.stream().filter(item -> {
      List<PersistentProperty> persistentProperties = item.getProperties();
      if(persistentProperties == null || persistentProperties.isEmpty()) {
        return false;
      }
      // 存在forminstanceId的才能作为主模型
      for (PersistentProperty persistentProperty : persistentProperties) {
        if(StringUtils.equals(persistentProperty.getPropertyName(), "formInstanceId")) {
          return true;
        }
      }
      return false;
    }).collect(Collectors.toList());
    return persistentClasses;
  }
  
  /* (non-Javadoc)
 * @see com.bizunited.platform.core.service.NebulaStaticPersistentService#findByPersistentClass(java.lang.String)
 */
@Override
  public PersistentClass findByPersistentClass(String className) {
    PersistentClassService persistentClassService = this.saturnContext.getPersistentClassService();
    return persistentClassService.queryByClassName(className);
  }
	
  /* (non-Javadoc)
   * @see com.bizunited.platform.core.service.NebulaStaticPersistentService#findPkPropertyByClass(java.lang.String)
   */
  @Override
  public PersistentProperty findPkPropertyByClass(String className) {
    PersistentPropertyService persistentPropertyService = this.saturnContext.getPersistentPropertyService();
    PersistentProperty pkProperty = persistentPropertyService.findPrimaryKey(className);
    return pkProperty;
  }
  
  /* (non-Javadoc)
   * @see com.bizunited.platform.core.service.NebulaStaticPersistentService#findByTargetPropertyName(java.lang.String, java.lang.String)
   */
  @Override
  public PersistentRelation findByTargetPropertyName(String className, String propertyName) {
    PersistentRelationService persistentRelationService = this.saturnContext.getPersistentRelationService();
    PersistentRelation persistentRelation = persistentRelationService.findByTargetPropertyName(className, propertyName);
    return persistentRelation;
  }
}