package com.bizunited.platform.core.service.internal;

import com.bizunited.platform.core.entity.ServicableMethodEntity;
import com.bizunited.platform.core.entity.ServicableMethodPropertyEntity;
import com.bizunited.platform.core.repository.ServicableMethodPropertyRepository;
import com.bizunited.platform.core.service.serviceable.ServicableMethodPropertyService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;

/**
 * @author yinwenjie
 */
@Service("ServicableMethodPropertyServiceImpl")
public class ServicableMethodPropertyServiceImpl implements ServicableMethodPropertyService {

  @Autowired
  private ServicableMethodPropertyRepository servicableMethodPropertyRepository;
  
  /* (non-Javadoc)
   * @see com.bizunited.platform.kuiper.starter.service.ServiceMethodPropertyService#create(com.bizunited.platform.kuiper.starter.entity.KuiperServiceMethodPropertyEntity)
   */
  @Override
  @Transactional
  public void create(ServicableMethodPropertyEntity serviceMethodProperty) {
    // 检验
    ServicableMethodEntity serviceMethod = serviceMethodProperty.getServiceMethod();
    Validate.notNull(serviceMethod , "没有发现当前明细信息的暴露服务，请检查!!");
    Integer paramType = serviceMethodProperty.getParamType();
    Validate.notNull(paramType , "必须记录当前参数的参数形态类型!!");
    if(paramType == 4) {
      String modelType = serviceMethodProperty.getModelType();
      Validate.notBlank(modelType , "当参数形态为业务性质的Model Object时，必须记录这个model object的完整类型!!");
    }
    Integer propertyIndex = serviceMethodProperty.getPropertyIndex();
    Validate.notNull(propertyIndex , "必须给定参数的索引号，请检查!!");
    
    servicableMethodPropertyRepository.saveAndFlush(serviceMethodProperty);
  }
}
