package com.bizunited.platform.core.service.invoke;

import java.lang.reflect.InvocationTargetException;

public abstract class AbstractHandleChain {
  /**
   * 如果之前对request的链的处理存在异常，则在这里就可以抛出了
   * @param context
   * @throws InvokeProxyException
   */
  protected void throwException(InvokeProxyContext context) throws InvokeProxyException{
    if(context.isException()) {
      Throwable e = context.getThrowable();
      if(e instanceof RuntimeException) {
        throw (RuntimeException)e;
      } else if(e instanceof InvokeProxyException) {
        throw (InvokeProxyException)e;
      } else {
        throw new InvokeProxyException(context, e.getCause());
      }
    } 
  }
  
  /**
   * 在出现异常时，记录到上下文中不急于抛出异常
   * @param context
   * @param e
   */
  protected void buildException(InvokeProxyContext context , Throwable e) {
    // 如果有异常，那么在这里进行记录
    context.setErrMsg(e.getMessage());
    context.setException(true);
    if(e instanceof InvocationTargetException) {
      InvocationTargetException invocation = (InvocationTargetException) e;
      Throwable taregete = invocation.getTargetException();
      context.setThrowable(taregete);
    } else {
      context.setThrowable(e);
    }
  }
}
