package com.bizunited.platform.core.service.invoke;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * 服务源调用链式结构中，负责各个节点进行信息通信的上下文构造
 * @author yinwenjie
 */
public class InvokeProxyContext {
  // ========= 以下区域为上下文中描述异常的区域（只有调用过程出现错误的情况下，这个区域才会填充值）
  /**
   * 异常全信息
   */
  private Throwable throwable;
  /**
   * 本次责任链调用过程是否发生了处理异常
   */
  private boolean isException = false;
  /**
   * 异常信息的概要描述
   */
  private String errMsg;
  // ========= 以上区域为上下文中描述异常的区域
  
  // ========= 以下区域为链式调用所需的各种相关的信息
  /**
   * 由于服务调用模块的工作环境比较复杂，所以在进行调用class查找等操作时不一定适用当前线程的类加载器。<br>
   * 所以整个服务调用模块所使用的类加载器都通过这里统一指定
   */
  private ClassLoader classLoader;
  /**
   * 这个K-V结构，用来保存在多个责任链处理之间，开发者所需要关联的多种自定义参数
   */
  private Map<String, Object> chainParams = new HashMap<>();
  /**
   * 存储handler调用过程的返回结果信息（如果有的话），并非最终的结果信息，responseFilter从这里取值，并对该值做处理
   */
  private Object result;
  // ========= 以上区域为链式调用所需的各种相关的信息

  public boolean isException() {
    return isException;
  } 

  public Throwable getThrowable() {
    return throwable;
  }

  public void setThrowable(Throwable throwable) {
    this.throwable = throwable;
  }

  public void setException(boolean isException) {
    this.isException = isException;
  }

  public String getErrMsg() {
    return errMsg;
  }

  public void setErrMsg(String errMsg) {
    this.errMsg = errMsg;
  }

  public ClassLoader getClassLoader() {
    return classLoader;
  }

  public void setClassLoader(ClassLoader classLoader) {
    this.classLoader = classLoader;
  }
  
  public Object getChainParam(String key) {
	return chainParams.get(key);
  }
  
  public void setChainParam(String key , Object value) {
	this.chainParams.put(key, value);
  }
  
  public void setChainParams(Map<String, Object> maps) {
	if(maps == null) {
	  return;
	}
	this.chainParams.putAll(maps);
  }

  public void setResult(Object result) {
    this.result = result;
  }
  
  public Object getResult() {
    return result;
  }
  /**
   * 该方法获得当前调用上下文中的所有参数keys信息
   * @return
   */
  public Set<String> getParamKeys() {
    return this.chainParams.keySet();
  }
}