package com.bizunited.platform.core.service.migrate;

/**
 * 基础工具套件中的关键数据迁移-迁出服务的定义在这里
 * @author yinwenjie
 */
public interface MigrateExportService {
  /**
   * 导出指定编号的数据视图、业务编码逻辑、字典逻辑、全局环境变量、远端服务源信息。并以压缩文件（zip文件）byte数组的形式进行调用返回
   * @param dataviewIds 指定导出的数据视图ID编号集合，如果不传入任何编号，说明不导出
   * @param codeRuleIds 指定导出的业务编码规则ID集合，如果不传入任何编号，说明不导出
   * @param dictIds 指定导出的字典业务编码规则ID集合，如果不传入任何编号，说明不导出
   * @param envIds 指定导出的全局环境变量ID集合，如果不传入任何编号，说明不导出
   * @param remoteServiceIds 指定导出的远端服务的ID集合，如果不传入任何编号，说明不导出
   * @return
   */
  public byte[] export(String[] dataviewIds , String[] codeRuleIds , String[] dictIds , String[] envIds , String[] remoteServiceIds);




}
