package com.bizunited.platform.core.service.scheduler;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

import com.bizunited.platform.core.entity.DynamicTaskSchedulerEntity;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeProxy;
import com.google.common.collect.Maps;

public class DynamicTask implements Runnable {
  /**
   * 当前的spring上下文
   */
  private ApplicationContext ctx;
  /**
   * 当期的动态任务
   */
  private DynamicTaskSchedulerEntity currentTask;
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(DynamicTask.class);
  
  /**
   * 动态任务周期性执行内容，其核心点是创建一个新的代理责任链，该责任链中有 指定的script脚本执行过程和 日志记录过程
   * @param currentTask 
   * @param ctx 
   */
  public DynamicTask(DynamicTaskSchedulerEntity currentTask , ApplicationContext ctx) {
    this.currentTask = currentTask;
    this.ctx = ctx;
  }
  
  @Override
  public void run() {
    /*
     * - 这里的执行过程是一个默认的责任链调用，过程包括：
     * 1、调用前开始时间等即时信息写入
     * 2、对指定的script脚本进行调用
     * 3、调用动态任务的任务记录服务
     * 以上调用过程不需要记录返回值
     * */
    InvokeProxy invokeProxy = (InvokeProxy)ctx.getBean("schedulerTaskProxy");
    Map<String, Object> params = Maps.newHashMap();
    params.put("currentTask" , currentTask);
    try {
      invokeProxy.doHandle(params);
    } catch (InvokeProxyException e) {
      LOGGER.error(e.getMessage() , e);
    }
  }
}
