package com.bizunited.platform.core.service.scheduler.handle;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.bizunited.platform.core.entity.DynamicTaskSchedulerEntity;
import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.invoke.HandleChain.ChainLogic;

/**
 * -该定义的处理节点，用于在动态任务功能中，调用指定的运行脚本
 * @author yinwenjie
 */
@Component("DynamicTaskInvokeHandle")
public class DynamicTaskInvokeHandle implements InvokeRequestHandle {
  @Autowired
  private ScriptService scriptService;
  
  @Override
  public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
    DynamicTaskSchedulerEntity currentTask = (DynamicTaskSchedulerEntity)context.getChainParam("currentTask");
    Validate.notNull(currentTask , "在进行动态任务执行时，未发现指定的动态调用任务!");
    Map<String, Object> parmas = new HashMap<>();
    parmas.put("currentTask", currentTask);
    // 脚本信息
    ScriptEntity scriptEntity = currentTask.getScript();
    String scriptId = scriptEntity.getId();
    
    // 可传入的信息包括：
    // context上下文中的chainParams信息
    Set<String> chainParamsKeys = context.getParamKeys();
    for (String chainParamsKey : chainParamsKeys) {
      parmas.put(chainParamsKey, context.getChainParam(chainParamsKey));
    }
    // spring上下文对象
    Map<String, Object> returnResults = null;
    returnResults = this.scriptService.invoke(scriptId, parmas);
    if(returnResults != null && !returnResults.isEmpty()) {
      context.setChainParams(returnResults);
    }
    chain.doHandle(context, ChainLogic.CONTINUE);
  }
}