package com.bizunited.platform.core.service.scheduler.handle;

import java.util.Date;

import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.bizunited.platform.core.entity.DynamicTaskSchedulerEntity;
import com.bizunited.platform.core.entity.DynamicTaskSchedulerLogEntity;
import com.bizunited.platform.core.service.DynamicTaskSchedulerLogService;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.HandleChain.ChainLogic;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeResponseHandle;

/**
 * 动态任务的调用日志处理
 * @author yinwenjie
 */
@Component("dynamicTaskInvokeLogHandle")
public class DynamicTaskInvokeLogHandle implements InvokeResponseHandle {
  @Autowired
  private DynamicTaskSchedulerLogService dynamicTaskSchedulerLogService;
  
  @Override
  public boolean handleException(InvokeProxyContext context) {
    return true;
  }
  
  @Override
  public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
    // 这是动态任务的业务编号
    Object currentTaskValue = context.getChainParam("currentTask");
    Validate.notNull(currentTaskValue , "在进行动态任务执行时，未发现指定的taskCode");
    DynamicTaskSchedulerEntity currentTask = (DynamicTaskSchedulerEntity)currentTaskValue;
    String taskCode = currentTask.getTaskCode();
    Validate.notBlank(taskCode , "在进行动态任务执行时，未发现指定的taskCode"); 
    // 这是调用的开始时间
    Date startTime = (Date)context.getChainParam("_timerRecord");
    Validate.notNull(startTime , "未发现调用的开始时间!!");
    // 这是当前结束时间
    Date endTime = new Date();
    
    /* 
     * -存储的方式包括两种：
     * 1、如果当前处理过程出现了异常（事务独立处理，因为无论处理过程是否正确，日志必须写入），主需要写入错误信息
     * 2、如果当前处理过程正常，则记录正常日志
     * */
    DynamicTaskSchedulerLogEntity log = new DynamicTaskSchedulerLogEntity();
    log.setDynamicTaskScheduler(currentTask); 
    log.setEndTime(endTime);
    log.setStartTime(startTime);
    log.setSuccess(!context.isException());
    // 如果条件成立，说明是情况1
    if(context.isException()) {
      log.setErrorContents(context.getErrMsg());
    } 
    this.dynamicTaskSchedulerLogService.create(log);
    chain.doHandle(context, ChainLogic.CONTINUE);
  } 
} 