package com.bizunited.platform.core.service.script;

import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.script.model.ScriptInputParamsModel;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * ScriptExecuteHandle 调用链-执行脚本
 *
 * @description:
 * @author: yanwe
 * @date: 27/May/2019 15:49
 */
@Component("GroovyScriptExecuteHandle")
public class ScriptExecuteHandle implements InvokeRequestHandle {

  @Autowired private ScriptService scriptService;

  @Override
  public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {

    // TODO  当前Handle粒度不够，后续进行调整

    // 获取传入上下文当中的 scriptInputParamsModel
    ScriptInputParamsModel model = (ScriptInputParamsModel) context.getChainParam("scriptInputParamsModel");
    Validate.notNull(model, "传入groovy入参不能为空！");
    Validate.notEmpty(model.getScriptIds(), "传入groovy入参中脚本ID不能为空！");
    // 遍历执行脚本
    for (String scriptId : model.getScriptIds()) {
      // 获取当前上下文全局变量参数
      Map<String, Object> currentContextParams = new HashMap<>();
      Set<String> contextKey = context.getParamKeys();
      if (!CollectionUtils.isEmpty(contextKey)) {
        for (String key : contextKey) {
          currentContextParams.put(key, context.getChainParam(key));
        }
      }
      Map<String, Object> result = this.scriptService.invoke(scriptId, currentContextParams);
      // 执行当前脚本完毕后，再将结果写入上下文
      if (!CollectionUtils.isEmpty(result)) {
        for (Map.Entry<String,Object> item : result.entrySet()) {
          context.setChainParam(item.getKey(), item.getValue());
        }
      }
    }
    chain.doHandle(context, HandleChain.ChainLogic.CONTINUE);
  }
}
