package com.bizunited.platform.core.service.script;

import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeResponseHandle;
import org.springframework.stereotype.Component;

/** 该处理器用户在执行所有GV脚本后，构建返回信息 注意，这个执行器可以在异常情况下工作 */
@Component("GroovyResultResponseHandle")
public class ScriptResultResponseHandle implements InvokeResponseHandle {

  @Override
  public boolean handleException(InvokeProxyContext context) {
    return false;
  }

  @Override
  public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {

    /*
     * Response 负责处理各个脚本运行结果，并组装成 json格式返还
     */
    // 商定已参数 resultKey 为返回结果的key
    Object result = context.getChainParam("resultKey");
    if(null!=result){
      context.setResult(result);
    }
  }
}
