package com.bizunited.platform.core.service.script.persistent;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.ehcache.Cache;

/**
 * SimplePersistentGroovyClassService
 * 存储/读取 内存中的脚本
 * @description:
 * @author: yanwe
 * @date: 23/May/2019 09:39
 */

class SimplePersistentGroovyClassService implements PeristentGroovyClassService {

  private Cache<String,Object> cache;

  public SimplePersistentGroovyClassService(Cache<String,Object> cache){
    this.cache = cache;
  }

  @Override
  public void save(String groovyName, Object groovyScript) {
    Validate.notNull(groovyScript,"groovyScript can not be null!");
    Validate.notBlank(groovyName,"groovyStr name cant not be null!");
    this.cache.put(groovyName,groovyScript);
  }

  @Override
  public void delete(String groovyName) {
    if(StringUtils.isBlank(groovyName)){
      return;
    }
    this.cache.remove(groovyName);
  }

  @Override
  public Object findByClassName(String groovyName) {
    return this.cache.get(groovyName);
  }
}
