package com.bizunited.platform.core.service.script.persistent;

import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;
import org.springframework.stereotype.Component;

/**
 * SimplePersistentGroovyServiceFactory
 * 脚本于内存中的存储/读取获取方法工厂
 * @description:
 * @author: yanwe
 * @date: 23/May/2019 09:57
 */
@Component
public class SimplePersistentGroovyServiceFactory extends PersistentGroovyServiceFactory {

  private static Cache<String, Object> cache = null;

  public SimplePersistentGroovyServiceFactory() {
    synchronized (SimplePersistentGroovyServiceFactory.class) {
      while (cache == null) {
        ResourcePools resourcePools = ResourcePoolsBuilder.heap(500).build();
        CacheManagerBuilder<CacheManager> build = CacheManagerBuilder.newCacheManagerBuilder();
        CacheManager cacheManager =
            build.withCache(
                    "preConfigured",
                    CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, Object.class, resourcePools))
                .withDefaultSizeOfMaxObjectSize(1024L, MemoryUnit.MB)
                .build(true);
        cache = cacheManager.getCache("preConfigured", String.class, Object.class);
      }
    }
  }

  @Override
  public PeristentGroovyClassService createPeristentGroovyClassService() {
    return new SimplePersistentGroovyClassService(cache);
  }
}

