package com.bizunited.platform.core.service.serviceable;

import com.bizunited.platform.core.entity.ServicableMethodEntity;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.Map;

/**
 * kuiper表单引擎服务源管理、调用的相关服务定义
 * @author yinwenjie
 */
public interface ServicableMethodService {
  
  /**
   * 添加一个新的表单暴露服务的描述，包括描述中的明细信息
   * @param serviceMethod
   */
  public void create(ServicableMethodEntity serviceMethod);
  /**
   * 非常危险的方式，删除服务暴露设置中所有的明细描述和基本信息。
   * 这个方法在初始化进程初始化时进行操作
   */
  public void deleteServiceMethodAndProperties();
  
  /**
   * 按照可能的服务源名称、服务源完整接口名、服务源方法简称查询条件，进行服务源信息查询
   * @param pageable
   * @param name 可能的服务源名称 查询条件
   * @param description 方法中文描述（支持模糊查询）
   * @param interfaceName 可能的服务源完整接口名 查询条件
   * @param simpleMethodName 可能的服务源方法简称 查询条件
   * @param returnClassName 可能的返回classname（全名）作为查询条件
   * @param propertyClassName 可能的参数类型classname（全名）作为查询条件
   * @param usedScope 服务源方法的应用范围：目前支持：读操作(READ)，写操作(WRITE)
   * @return
   */
  public Page<ServicableMethodEntity> findByConditions(Pageable pageable, String name, String description, String interfaceName, String simpleMethodName, String returnClassName, String propertyClassName, String usedScope);
  /**
   * 进行“写”性质的服务源代理调用
   * @param params 调用时的参数信息，会写入到调用上下文中
   * @return
   */
  public Object writeInvoke(Map<String, Object> params) throws InvokeProxyException;
  /**
   * 进行“读”性质的服务源代理调用
   * @param params 调用时的参数信息，会写入到调用上下文中
   * @return
   */
  public Object readInvoke(Map<String, Object> params) throws InvokeProxyException;
  /**
   * 根据name值  查询服务源信息以及该服务源的参数信息等
   * @param name
   * @return
   */
  public ServicableMethodEntity findDetailsByName(String name);
  /**
   * 根据name值  查询服务源信息
   * @param name
   * @return
   */
  public ServicableMethodEntity findByName(String name);
}
