/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.configuration;

import com.bizunited.platform.core.service.invoke.DefaultHandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxy;
import com.bizunited.platform.core.service.invoke.handle.request.TimerRecordHandle;
import com.bizunited.platform.core.service.scheduler.DynamicTaskNotifyMaster;
import com.bizunited.platform.core.service.scheduler.handle.DynamicTaskInvokeHandle;
import com.bizunited.platform.core.service.scheduler.handle.DynamicTaskInvokeLogHandle;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Component;

@Configuration
@EnableAsync
@Component(value="_schedulerConfig")
public class SchedulerConfig
implements CommandLineRunner {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DynamicTaskNotifyMaster dynamicTaskNotifyMaster;
    @Autowired
    private TimerRecordHandle timerRecordHandle;
    @Autowired
    private DynamicTaskInvokeHandle dynamicTaskInvokeHandle;
    @Autowired
    private DynamicTaskInvokeLogHandle dynamicTaskInvokeLogHandle;

    @Bean(value={"platform_dynamicTaskScheduler"})
    public ThreadPoolTaskScheduler getThreadPoolTaskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setBeanName("platform_dynamicTaskScheduler");
        scheduler.setDaemon(false);
        scheduler.setPoolSize(50);
        scheduler.setThreadFactory(this.getThreadFactory());
        scheduler.setThreadNamePrefix("platform_");
        return scheduler;
    }

    private ThreadFactory getThreadFactory() {
        ThreadFactory dynamicTaskSchedulerFactory = new ThreadFactory(){
            private AtomicInteger count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread currentThread = new Thread(r);
                ClassLoader classLoader = SchedulerConfig.this.applicationContext.getClassLoader();
                currentThread.setDaemon(false);
                currentThread.setName("dynamicTask_" + this.count.getAndIncrement());
                currentThread.setContextClassLoader(classLoader);
                return currentThread;
            }
        };
        return dynamicTaskSchedulerFactory;
    }

    @Bean(value={"schedulerTaskProxy"})
    @Scope(value="prototype")
    public InvokeProxy getSchedulerTaskProxyInvoke() {
        InvokeProxy.Build build = new InvokeProxy.Build();
        InvokeProxy invokeProxy = build.addInvokeRequestFilter(this.timerRecordHandle, this.dynamicTaskInvokeHandle).addInvokeResponseFilter(this.dynamicTaskInvokeLogHandle).setTargetHandleChain(DefaultHandleChain.class).addClassLoader(this.applicationContext.getClassLoader()).build();
        return invokeProxy;
    }

    public void run(String ... args) throws Exception {
        this.dynamicTaskNotifyMaster.notifyMaster();
    }
}

