/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.configuration;

import com.bizunited.platform.core.service.init.InitProcessService;
import com.bizunited.platform.rbac.server.service.redis.RedisMutexService;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component(value="SystemInitConfig")
public class SystemInitConfig
implements CommandLineRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemInitConfig.class);
    @Autowired(required=false)
    private List<InitProcessService> initProcessServices;
    @Autowired
    private RedisMutexService redisMutexService;

    @Transactional
    public void run(String ... args) throws Exception {
        if (this.initProcessServices == null || this.initProcessServices.isEmpty()) {
            return;
        }
        List<InitProcessService> queue = this.initProcessServices.stream().sorted((t, s) -> t.sort() - s.sort()).collect(Collectors.toList());
        try {
            this.redisMutexService.lock("_starting");
            this.init(queue);
            LOGGER.info("....system init process dome!");
        }
        catch (RuntimeException e) {
            LOGGER.info("....system init process error!");
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        finally {
            this.redisMutexService.unlock("_starting");
        }
    }

    private void init(List<InitProcessService> queue) {
        for (InitProcessService initProcessService : queue) {
            try {
                boolean doProcess = initProcessService.doProcess();
                if (!doProcess) continue;
                initProcessService.init();
            }
            catch (RuntimeException e) {
                boolean stopOnException = initProcessService.stopOnException();
                if (!stopOnException) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                    continue;
                }
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }
}

