/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.bizunited.platform.core.controller.model.ResponseCode;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.text.Format;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import springfox.documentation.annotations.ApiIgnore;

@ApiIgnore
public class BaseController {
    private static final Logger LOG = LoggerFactory.getLogger(BaseController.class);

    protected String getPrincipalAccount() {
        Principal userPrincipal = this.getPrincipal();
        String account = userPrincipal.getName();
        Validate.notBlank((CharSequence)account, (String)"not found op user!", (Object[])new Object[0]);
        return account;
    }

    protected Principal getPrincipal() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Validate.notNull((Object)authentication, (String)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7cfb\u7edf\u7684\u767b\u5f55\u4eba", (Object[])new Object[0]);
        return authentication;
    }

    protected ResponseModel buildHttpResultForException(Exception e) {
        ResponseModel result = new ResponseModel(new Date().getTime(), null, ResponseCode.E501, e);
        return result;
    }

    protected ResponseModel buildHttpResult() {
        return new ResponseModel(new Date().getTime(), null, ResponseCode.E0, null);
    }

    protected ResponseModel buildHttpResult(Object data) {
        return new ResponseModel(new Date().getTime(), data, ResponseCode.E0, null);
    }

    protected <T> ResponseModel buildHttpResultW(Iterable<T> page, String ... properties) {
        ResponseModel result = new ResponseModel(new Date().getTime(), null, ResponseCode.E0, null);
        if (page == null) {
            result.setData(page);
            return result;
        }
        try {
            for (T item : page) {
                this.filterPropertyW(item, item.getClass(), new LinkedList<String>(), properties);
            }
            result.setData(page);
        }
        catch (Exception e) {
            result.setErrorMsg(e.getMessage());
            result.setMessage(e.getMessage());
            result.setResponseCode(ResponseCode.E501);
            result.setSuccess(false);
        }
        return result;
    }

    protected <T> ResponseModel buildHttpResultW(Collection<T> entities, String ... properties) {
        ResponseModel result = new ResponseModel(new Date().getTime(), null, ResponseCode.E0, null);
        if (entities == null || entities.isEmpty()) {
            result.setData(entities);
            return result;
        }
        try {
            for (T item : entities) {
                this.filterPropertyW(item, item.getClass(), new LinkedList<String>(), properties);
            }
            result.setData(entities);
        }
        catch (Exception e) {
            result.setErrorMsg(e.getMessage());
            result.setMessage(e.getMessage());
            result.setResponseCode(ResponseCode.E501);
            result.setSuccess(false);
        }
        return result;
    }

    protected <T> ResponseModel buildHttpResultW(T entity, String ... properties) {
        ResponseModel result = new ResponseModel(new Date().getTime(), null, ResponseCode.E0, null);
        if (entity == null) {
            return result;
        }
        Class<?> objectClass = entity.getClass();
        try {
            this.filterPropertyW(entity, objectClass, new LinkedList<String>(), properties);
        }
        catch (Exception e) {
            result.setErrorMsg(e.getMessage());
            result.setMessage(e.getMessage());
            result.setResponseCode(ResponseCode.E501);
            result.setSuccess(false);
        }
        result.setData(entity);
        return result;
    }

    private void filterPropertyW(Object currentObject, Class<?> currentClass, LinkedList<String> parentProperties, String ... properties) throws SecurityException, IllegalAccessException, InvocationTargetException {
        if (parentProperties == null) {
            parentProperties = Lists.newLinkedList();
        }
        if (currentObject == null) {
            return;
        }
        Field[] fields = currentClass.getDeclaredFields();
        if (fields == null || fields.length == 0) {
            return;
        }
        Class<?> superClass = null;
        superClass = currentClass.getSuperclass();
        if (superClass != null) {
            this.filterPropertyW(currentObject, superClass, parentProperties, properties);
        }
        for (Field fieldItem : fields) {
            String currentFieldName = fieldItem.getName();
            Method getMethod = null;
            Method setMethod = null;
            Class<?> fieldClass = fieldItem.getType();
            try {
                char[] chars = currentFieldName.toCharArray();
                chars[0] = (char)(chars[0] - 32);
                getMethod = currentClass.getMethod("get" + String.valueOf(chars), new Class[0]);
                chars = currentFieldName.toCharArray();
                chars[0] = (char)(chars[0] - 32);
                setMethod = currentClass.getMethod("set" + String.valueOf(chars), fieldClass);
            }
            catch (NoSuchMethodException | RuntimeException e) {
                LOG.debug(e.getMessage());
            }
            if (getMethod == null || setMethod == null) continue;
            String currentFieldNames = null;
            if (parentProperties != null && !parentProperties.isEmpty()) {
                Object[] fieldNames = parentProperties.toArray(new String[0]);
                currentFieldNames = StringUtils.join((Object[])new String[]{StringUtils.join((Object[])fieldNames, (String)"."), ".", currentFieldName});
            } else {
                currentFieldNames = currentFieldName;
            }
            if (this.baseForPropertyW(fieldItem)) continue;
            if (Collection.class.isAssignableFrom(fieldClass)) {
                if (properties == null || properties.length == 0 || !Arrays.asList(properties).contains(currentFieldNames)) {
                    setMethod.invoke(currentObject, new Object[]{null});
                    continue;
                }
                Object fieldValue = getMethod.invoke(currentObject, new Object[0]);
                if (fieldValue == null) continue;
                parentProperties.addLast(currentFieldName);
                Collection collections = (Collection)fieldValue;
                for (Object propertyObject : collections) {
                    Class<?> propertyClass = propertyObject.getClass();
                    this.filterPropertyW(propertyObject, propertyClass, parentProperties, properties);
                }
                parentProperties.removeLast();
                continue;
            }
            if (!this.baseForPropertyW(fieldItem) && Arrays.asList(properties).contains(currentFieldNames)) {
                if (properties == null || properties.length == 0) {
                    setMethod.invoke(currentObject, new Object[]{null});
                    continue;
                }
                Object currentFieldValue = getMethod.invoke(currentObject, new Object[0]);
                if (currentFieldValue == null) continue;
                parentProperties.addLast(currentFieldName);
                this.filterPropertyW(currentFieldValue, currentFieldValue.getClass(), parentProperties, properties);
                parentProperties.removeLast();
                continue;
            }
            setMethod.invoke(currentObject, new Object[]{null});
        }
    }

    protected void writeResponseFile(HttpServletResponse response, int httpType, byte[] result) {
        if (httpType == 1) {
            response.setContentType("image/jpeg;charset=utf-8");
        } else if (httpType == 2) {
            response.setContentType("audio/mp3;charset=utf-8");
        } else if (httpType == 3) {
            response.setContentType("video/mpeg4;charset=utf-8");
        } else {
            throw new IllegalArgumentException("\u672a\u77e5\u6587\u4ef6\u7c7b\u578b");
        }
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            out.write(result);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    protected void writeResponseFile(HttpServletRequest request, HttpServletResponse response, byte[] result, String fileName) {
        String currentFileName = "";
        try {
            currentFileName = StringUtils.isBlank((CharSequence)fileName) ? "temp" : URLEncoder.encode(fileName, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            currentFileName = "temp";
        }
        response.setContentType("application/octet-stream;charset=utf-8");
        response.addHeader("Content-Disposition", "attachment;fileName=" + this.encodeFileName(request, currentFileName));
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            out.write(result);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private String encodeFileName(HttpServletRequest request, String fileName) {
        String agent = request.getHeader("User-Agent");
        if (StringUtils.isBlank((CharSequence)agent)) {
            try {
                return URLEncoder.encode(fileName, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
        if (agent.contains("Firefox") || agent.contains("Safari")) {
            fileName = new String(fileName.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
        } else if (agent.contains("Chrome")) {
            try {
                fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
        return fileName;
    }

    private boolean baseForPropertyW(Field fieldItem) {
        Class<?> fieldItemClass = fieldItem.getType();
        if (fieldItemClass.isPrimitive() || fieldItemClass == Byte.TYPE || fieldItemClass == Short.TYPE || fieldItemClass == Integer.TYPE || fieldItemClass == Long.TYPE || fieldItemClass == Float.TYPE || fieldItemClass == Double.TYPE || fieldItemClass == Character.TYPE || fieldItemClass == Boolean.TYPE || fieldItemClass == Byte.class || fieldItemClass == Short.class || fieldItemClass == Integer.class || fieldItemClass == Long.class || fieldItemClass == Float.class || fieldItemClass == Double.class || fieldItemClass == Character.class || fieldItemClass == Boolean.class) {
            return true;
        }
        if (CharSequence.class.isAssignableFrom(fieldItemClass)) {
            return true;
        }
        return Date.class.isAssignableFrom(fieldItemClass) || Number.class.isAssignableFrom(fieldItemClass) || Format.class.isAssignableFrom(fieldItemClass);
    }
}

