/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.rbac.server.service.OrganizationService;
import com.bizunited.platform.rbac.server.vo.OrganizationVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/orgs"})
public class OrganizationController
extends BaseController {
    @Autowired
    private OrganizationService organizationService;
    private static final Logger LOGGER = LoggerFactory.getLogger(OrganizationController.class);

    @ApiOperation(value="\u6dfb\u52a0\u7ec4\u7ec7\u673a\u6784")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseModel create(@ApiParam(name="\u7ec4\u7ec7\u673a\u6784\u76f8\u5173\u4fe1\u606f") @RequestBody OrganizationVo organization) {
        LOGGER.debug("\u7528\u6237\u7ec4:{}", (Object)JSON.toJSONString((Object)organization));
        try {
            OrganizationVo organizationVo = this.organizationService.create(organization);
            return this.buildHttpResultW(organizationVo, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u7ec4\u7ec7\u673a\u6784")
    @RequestMapping(value={"/update"}, method={RequestMethod.PATCH})
    public ResponseModel update(@ApiParam(name="\u7ec4\u7ec7\u673a\u6784\u76f8\u5173\u4fe1\u606f") @RequestBody OrganizationVo organizationEntity) {
        LOGGER.debug("\u8981\u4fee\u6539\u7684\u7528\u6237\u7ec4\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)organizationEntity));
        try {
            OrganizationVo organizationVo = this.organizationService.update(organizationEntity);
            return this.buildHttpResultW(organizationVo, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u72b6\u6001---(\u542f\u7528\u3001\u7981\u7528)")
    @RequestMapping(value={"/updateStatus/{orgId}"}, method={RequestMethod.PATCH})
    public ResponseModel updateStatus(@PathVariable(value="orgId") String orgId) {
        LOGGER.debug("\u7ec4\u7ec7\u673a\u6784id:{}", (Object)orgId);
        try {
            OrganizationVo organization = this.organizationService.updateStatus(orgId);
            return this.buildHttpResultW(organization, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5bf9\u4e00\u4e2a\u6307\u5b9a\u7684currentOrgId\u8fdb\u884c\u5176\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784parentOrgId\u7684\u7ed1\u5b9a\u64cd\u4f5c\uff08\u539f\u6709currentOrgId\u7684\u7236\u7ea7\u4fe1\u606f\u5c06\u4f1a\u88ab\u53d6\u6d88\uff09")
    @RequestMapping(value={"/bindParent"}, method={RequestMethod.PATCH})
    public ResponseModel bindParent(@RequestParam(name="currentOrgId") @ApiParam(name="currentOrgId", value="\u5f53\u524d\u7684\u7ec4\u7ec7\u7ed3\u6784\u7f16\u53f7") String currentOrgId, @RequestParam(name="parentOrgId") @ApiParam(name="parentOrgId", value="\u5f53\u524d\u9700\u8981\u7ed1\u5b9a\u7684\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u7f16\u53f7") String parentOrgId) {
        try {
            this.organizationService.bindParent(currentOrgId, parentOrgId);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5bf9\u4e00\u4e2a\u6307\u5b9a\u7684currentOrgId\u53d6\u6d88\u5176\u5f53\u524d\u7236\u7ea7\u5173\u7cfb\u7684\u7ed1\u5b9a\u4fe1\u606f")
    @RequestMapping(value={"/unbindParent"}, method={RequestMethod.PATCH})
    public ResponseModel unbindParent(@RequestParam(name="currentOrgId") @ApiParam(name="currentOrgId", value="\u5f53\u524d\u7684\u7ec4\u7ec7\u7ed3\u6784\u7f16\u53f7") String currentOrgId) {
        try {
            this.organizationService.unbindParent(currentOrgId);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5c06\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\uff08currentOrgId\uff09\u548c\u6307\u5b9a\u7684\u4e00\u4e2a/\u591a\u4e2a\u7528\u6237\u6570\u636e\u7f16\u53f7\uff08userId\uff09\u5f62\u6210\u7ed1\u5b9a\u5173\u7cfb\u2014\u2014\u4e00\u4e2a\u7528\u6237\u53ea\u80fd\u5c5e\u4e8e\u4e00\u4e2a\u7ec4\u7ec7\u673a\u6784", notes="\u6ce8\u610f\uff0c\u76ee\u524d\u4e00\u4e2a\u4eba\u5458\u53ef\u4ee5\u548c\u591a\u4e2a\u7ec4\u7ec7\u673a\u6784\u8fdb\u884c\u7ed1\u5b9a\uff0c\u4f46\u662f\u5462\u4e00\u4e2a\u4eba\u5458\u6700\u591a\u53ea\u80fd\u548c\u4e00\u4e2a\u7ec4\u7ec7\u673a\u6784\u7ed1\u5b9a\u4e00\u6b21")
    @RequestMapping(value={"/bindUsers"}, method={RequestMethod.PATCH})
    public ResponseModel bindUsers(@RequestParam(name="currentOrgId") @ApiParam(name="currentOrgId", value="\u5f53\u524d\u7684\u7ec4\u7ec7\u7ed3\u6784\u7f16\u53f7") String currentOrgId, @RequestParam(name="userIds") @ApiParam(name="userIds", value="\u6307\u5b9a\u7684\u4e00\u4e2a/\u591a\u4e2a\u7528\u6237\u6570\u636e\u7f16\u53f7\uff08userId\uff09") String[] userIds) {
        try {
            this.organizationService.bindUsers(currentOrgId, userIds);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u89e3\u9664\u6307\u5b9a\u7528\u6237\u548c\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\u7684\u7ed1\u5b9a\u5173\u7cfb")
    @RequestMapping(value={"/unbindUsers"}, method={RequestMethod.PATCH})
    public ResponseModel unbindUsers(@RequestParam(name="currentOrgId") @ApiParam(name="currentOrgId", value="\u6307\u5b9a\u7684\u7ec4\u7ec7\u673a\u6784\u6570\u636e\u5e93\u7f16\u53f7") String currentOrgId, @RequestParam(name="userId") @ApiParam(name="userId", value="\u5f53\u524d\u9700\u8981\u64cd\u4f5c\u7684\u4eba\u5458id\u4fe1\u606f") String[] userId) {
        try {
            this.organizationService.unbindUser(currentOrgId, userId);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5c06\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\uff08currentOrgId\uff09\u548c\u6307\u5b9a\u7684\u4e00\u4e2a/\u591a\u4e2a\u89d2\u8272\u5f62\u6210\u7ed1\u5b9a\u5173\u7cfb\u2014\u2014\u4e00\u4e2a\u89d2\u8272\u53ea\u80fd\u5c5e\u4e8e\u4e00\u4e2a\u7ec4\u7ec7\u673a\u6784")
    @RequestMapping(value={"/bindRoles"}, method={RequestMethod.PATCH})
    public ResponseModel bindRoles(@RequestParam(name="currentOrgId") @ApiParam(name="currentOrgId", value="\u5f53\u524d\u7684\u7ec4\u7ec7\u7ed3\u6784\u7f16\u53f7") String currentOrgId, @RequestParam(name="roleIds") @ApiParam(name="roleIds", value="\u6307\u5b9a\u7684\u4e00\u4e2a/\u591a\u4e2a\u7528\u6237\u6570\u636e\u7f16\u53f7\uff08roleId\uff09") String[] roleIds) {
        try {
            this.organizationService.bindRoles(currentOrgId, roleIds);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u89e3\u9664\u6307\u5b9a\u89d2\u8272\u548c\u4efb\u4f55\u7ec4\u7ec7\u673a\u6784\u7684\u7ed1\u5b9a\u5173\u7cfb")
    @RequestMapping(value={"/unbindRoles"}, method={RequestMethod.PATCH})
    public ResponseModel unBindRoles(@RequestParam(name="roleId") @ApiParam(name="roleId", value="\u5f53\u524d\u9700\u8981\u89e3\u7ed1\u7684\u89d2\u8272id") String[] roleId) {
        try {
            this.organizationService.unbindRole(roleId);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u76ee\u524d\u6ca1\u6709\u6307\u5b9a\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u7684\u6240\u6709\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff0c\u65e0\u8bba\u5176\u72b6\u6001\u662f\u5426\u6b63\u5e38\uff08status\u65e0\u8bba\u4ec0\u4e48\u503c\uff09", notes="\u6ce8\u610f\uff1a(\u67e5\u8be2\u7684\u4fe1\u606f\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f)")
    @RequestMapping(value={"/findByNullParent"}, method={RequestMethod.GET})
    public ResponseModel findByNullParent() {
        try {
            List resutls = this.organizationService.findByNullParent();
            return this.buildHttpResultW(resutls, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6307\u5b9a\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u4e0b\u7684\u6240\u6709\u5b50\u7ea7\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff0c\u65e0\u8bba\u5176\u72b6\u6001\u662f\u5426\u6b63\u5e38\uff08status\u65e0\u8bba\u4ec0\u4e48\u503c\uff09", notes="\u6ce8\u610f\uff1a(\u67e5\u8be2\u7684\u4fe1\u606f\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f)")
    @RequestMapping(value={"/findByParent"}, method={RequestMethod.GET})
    public ResponseModel findByParent(@RequestParam(name="parentId") @ApiParam(name="parentId", value="\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784id") String parentId) {
        try {
            List resutls = this.organizationService.findByParent(parentId);
            return this.buildHttpResultW(resutls, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u76ee\u524d\u6ca1\u6709\u6307\u5b9a\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u7684\u6240\u6709\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff0c\u5e76\u4e14\u4f9d\u636e\u5176\u72b6\u6001\u8fdb\u884c\u67e5\u8be2", notes="\u6ce8\u610f\uff1a(\u67e5\u8be2\u7684\u4fe1\u606f\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f)")
    @RequestMapping(value={"/findByNullParentAndStatus"}, method={RequestMethod.GET})
    public ResponseModel findByNullParentAndStatus(@RequestParam(name="status") @ApiParam(name="status", value="\u72b6\u6001\u4fe1\u606f\uff081:\u6b63\u5e38\uff1b0\u7981\u7528/\u5f02\u5e38\uff09") Integer status) {
        try {
            List resutls = this.organizationService.findByNullParentAndStatus(status);
            return this.buildHttpResultW(resutls, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6307\u5b9a\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u4e0b\u7684\u6240\u6709\u5b50\u7ea7\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff0c\u5e76\u4e14\u4f9d\u636e\u5176\u72b6\u6001\u8fdb\u884c\u67e5\u8be2", notes="\u6ce8\u610f\uff1a(\u67e5\u8be2\u7684\u4fe1\u606f\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f)")
    @RequestMapping(value={"/findByParentAndStatus"}, method={RequestMethod.GET})
    public ResponseModel findByParentAndStatus(@RequestParam(name="parentId") @ApiParam(name="parentId", value="\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784id") String parentId, @RequestParam(name="status") @ApiParam(name="status", value="\u72b6\u6001\u4fe1\u606f\uff081:\u6b63\u5e38\uff1b0\u7981\u7528/\u5f02\u5e38\uff09") Integer status) {
        try {
            List resutls = this.organizationService.findByParentAndStatus(parentId, status);
            return this.buildHttpResultW(resutls, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\uff0c\u67e5\u8be2\u8fd9\u4e2a\u7ec4\u7ec7\u673a\u6784\u4ee5\u53ca\u8fd9\u4e2a\u7ec4\u7ec7\uff08\u8fd9\u4e9b\u7ec4\u7ec7\u673a\u6784\uff09\u5bf9\u5e94\u7684\u6240\u6709\u7236\u7ea7\u3001\u5b50\u7ea7\u7ed3\u6784\u4fe1\u606f")
    @RequestMapping(value={"/findByOrgName"}, method={RequestMethod.GET})
    public ResponseModel findByOrgName(@RequestParam(name="orgName") @ApiParam(name="orgName", value="\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u4fe1\u606f") String orgName) {
        try {
            JSONArray resutls = this.organizationService.findByOrgName(orgName);
            return this.buildHttpResultW(resutls, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6307\u5b9a\u7ec4\u7ec7\u4e0b\u7684\u8be6\u7ec6\u4fe1\u606f\uff0c\u65e0\u8bba\u5176\u72b6\u6001\u662f\u5426\u6b63\u5e38\uff08status\u65e0\u8bba\u4ec0\u4e48\u503c\uff09", notes="\u6ce8\u610f\uff1a\u5305\u62ec\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"/findDetailsById"}, method={RequestMethod.GET})
    public ResponseModel findDetailsById(@RequestParam(name="id") @ApiParam(name="id", value="\u7ec4\u7ec7\u673a\u6784id") String id) {
        try {
            OrganizationVo organization = this.organizationService.findDetailsById(id);
            return this.buildHttpResultW(organization, "parent", "child", "users", "roles");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\uff0c\u67e5\u8be2\u8fd9\u4e2a\u7ec4\u7ec7\u673a\u6784\u4ee5\u53ca\u8fd9\u4e2a\u7ec4\u7ec7\uff08\u8fd9\u4e9b\u7ec4\u7ec7\u673a\u6784\uff09\u5bf9\u5e94\u7684\u6240\u6709\u5b50\u7ea7\u7ed3\u6784\u4fe1\u606f")
    @RequestMapping(value={"/findUnbindOrgById"}, method={RequestMethod.GET})
    public ResponseModel findUnbindOrgById(@RequestParam(name="currentOrgId") @ApiParam(name="currentOrgId", value="\u5f53\u524d\u7ec4\u7ec7\u673a\u6784") String currentOrgId) {
        try {
            Object[] resutls = this.organizationService.findUnbindOrgById(currentOrgId);
            return this.buildHttpResultW(resutls, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff0c\u65e0\u8bba\u5176\u72b6\u6001\u662f\u5426\u6b63\u5e38\uff08status\u65e0\u8bba\u4ec0\u4e48\u503c\uff09", notes="\u6ce8\u610f\uff1a(\u67e5\u8be2\u7684\u4fe1\u606f\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f)")
    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResponseModel findAll() {
        try {
            List resutls = this.organizationService.findAll();
            return this.buildHttpResultW(resutls, new String[]{"parent"});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u9884\u5236\u63a7\u4ef6\u67e5\u8be2\uff0c\u67e5\u8be2\u7528\u6237\u7ec4\u7ec7\u673a\u6784\u76f8\u5173\u4fe1\u606f")
    @RequestMapping(value={"/findOrgByUserId"}, method={RequestMethod.GET})
    public ResponseModel findOrgByUserId(@ApiParam(name="userId", value="\u7528\u6237id\u4fe1\u606f") @RequestParam(value="userId") String userId) {
        try {
            OrganizationVo org = this.organizationService.findOrgByUserId(userId);
            return this.buildHttpResultW(org, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u7ec4\u7ec7\u673a\u6784\u76f8\u5173\u4fe1\u606f")
    @RequestMapping(value={"/findByIds"}, method={RequestMethod.POST})
    public ResponseModel findByIds(@RequestBody List<String> ids) {
        try {
            Set org = this.organizationService.findByIds(ids);
            return this.buildHttpResultW(org, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

