/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.core.service.script.model.ScriptInputParamsModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="ScriptController", tags={"\u811a\u672c\u94fe\u8c03\u7528"})
@RestController
@RequestMapping(value={"/v1/nebula/scripts"})
public class ScriptController
extends BaseController {
    @Autowired
    private ScriptService scriptService;

    @ApiOperation(value="\u540e\u7aef\u811a\u672c\u6267\u884c")
    @RequestMapping(value={"/invoke"}, method={RequestMethod.POST})
    public ResponseModel invoke(@RequestBody ScriptInputParamsModel scriptInputParamsModel) {
        try {
            Validate.notNull((Object)scriptInputParamsModel, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty(scriptInputParamsModel.getScriptIds(), (String)"\u811a\u672cID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Object result = this.scriptService.invoke(scriptInputParamsModel);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (Exception e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @RequestMapping(value={"/findByConditions"}, method={RequestMethod.GET})
    public ResponseModel findByConditions(@RequestParam(name="name") String name, @RequestParam(name="language") String language, Pageable pageable) {
        try {
            Page<ScriptEntity> page = this.scriptService.findByConditions(pageable, name, language);
            return this.buildHttpResultW(page, new String[0]);
        }
        catch (Exception e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u811a\u672c\u5185\u5bb9")
    @RequestMapping(value={"/findContentById"}, method={RequestMethod.GET})
    public ResponseModel findContentById(@RequestParam(name="scriptId") String scriptId) {
        try {
            String content = this.scriptService.findContentById(scriptId);
            return this.buildHttpResultW(content, new String[0]);
        }
        catch (Exception e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u811a\u672c\u57fa\u7840\u4fe1\u606f")
    @RequestMapping(value={"/findById"}, method={RequestMethod.GET})
    public ResponseModel findById(@RequestParam(name="scriptId") String scriptId) {
        try {
            ScriptEntity entity = this.scriptService.findById(scriptId);
            return this.buildHttpResultW(entity, new String[0]);
        }
        catch (Exception e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fdd\u5b58\u811a\u672c\u81f4\u6587\u4ef6\u7cfb\u7edf")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseModel create(@RequestParam(name="scriptEntity") String scriptEntityStr, @RequestParam(name="scriptContent") String scriptContent) {
        try {
            ScriptEntity scriptEntity = (ScriptEntity)JSONObject.parseObject((String)scriptEntityStr, ScriptEntity.class);
            ScriptEntity result = this.scriptService.create(scriptEntity, scriptContent);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (Exception e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u811a\u672c\u81f4\u6587\u4ef6\u7cfb\u7edf")
    @RequestMapping(value={"/update"}, method={RequestMethod.PATCH})
    public ResponseModel update(@RequestParam(name="scriptEntity") String scriptEntityStr, @RequestParam(name="scriptContent") String scriptContent) {
        try {
            ScriptEntity scriptEntity = (ScriptEntity)JSONObject.parseObject((String)scriptEntityStr, ScriptEntity.class);
            ScriptEntity result = this.scriptService.update(scriptEntity, scriptContent);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (Exception e) {
            return this.buildHttpResultForException(e);
        }
    }
}

